//
//  SpeakProfileMoreTableViewCell.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/7/29.
//

import UIKit

class SpeakProfileMoreTableViewCell: UITableViewCell {

    static let id = "SpeakProfileMoreTableViewCell"
    
    @IBOutlet weak var SpeakMoreProState: UIButton!
    @IBOutlet weak var SpeakMoreProTitleL: UILabel!
    @IBOutlet weak var SpeakMoreProLineV: UIView!
    
    var isTop = false
    var isBot = false
    
    override func awakeFromNib() {
        super.awakeFromNib()
        self.backgroundColor = .white
    }
    
    override func layoutSubviews() {
        super.layoutSubviews()
        SpeakMoreProLineV.isHidden = isBot
        if isTop && isBot {
            self.cornerRect(radius: 16, [.allCorners])
        }else if isTop {
            self.cornerRect(radius: 16, [.topLeft,.topRight])
        }else if isBot {
            self.cornerRect(radius: 16, [.bottomLeft,.bottomRight])
        }else{
            self.cornerRect(radius: 0, [.allCorners])
        }
    }
    
}
