//
//  SpeakEleProfileSwtichCell.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/7/23.
//

import UIKit

class SpeakEleProfileSwtichCell: UITableViewCell {

    static let id = "SpeakEleProfileSwtichCell"
    
    @IBOutlet weak var SpeakProfileSwitchIcon: UIImageView!
    @IBOutlet weak var SpeakProfileTitleL: UILabel!
    @IBOutlet weak var SpeakProfileSwitch: UISwitch!
    
    @IBOutlet weak var SpeakProfileLineV: UIView!
    
    
    var isTop:Bool = false
    var isBot:Bool = false
    
    override func awakeFromNib() {
        super.awakeFromNib()
        self.selectionStyle = .none
    }
    
    var data:SpeakEleProfileDescModel? {
        didSet{
            let icon = "icon_\(data?.title?.rawValue ?? "")"
            SpeakProfileSwitchIcon.image = UIImage(named: icon)
            SpeakProfileTitleL.text = data?.title?.rawValue
            if data?.title == .Learn {
                SpeakProfileSwitch.isOn = (SpeakElePublicManager.share.userInfo.learnedNative == 1)
            }
            
        }
    }
    
    override func layoutSubviews() {
        super.layoutSubviews()
        SpeakProfileLineV.isHidden = isBot
        self.layer.masksToBounds = false
        if isTop {
            contentView.cornerRect(radius: 16, [.topLeft,.topRight])
            contentView.addShadow(to: [.top,.left,.right] ,shadowColor: .init(hex: 0x595959) ,shadowOpacity: 0.1 ,shadowRadius: 16 ,shadowSpread: 4)
        }else if isBot {
            contentView.cornerRect(radius: 16, [.bottomLeft,.bottomRight])
            contentView.addShadow(to: [.bottom,.left,.right] ,shadowColor: .init(hex: 0x595959) ,shadowOpacity: 0.1 ,shadowRadius: 16 ,shadowSpread: 4)
        }else{
            contentView.cornerRect(radius: 0, [.bottomLeft,.bottomRight,.topLeft,.topRight])
            contentView.addShadow(to: [.left,.right] ,shadowColor: .init(hex: 0x595959) ,shadowOpacity: 0.1 ,shadowRadius: 16 ,shadowSpread: 4)
        }
    }
    
    @IBAction func ValueChange(_ sender: UISwitch) {
        if let call = callblack {
            call(sender.isOn)
        }
    }
}
