//
//  SpeakEleProfileHeaderView.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/7/24.
//

import UIKit

class SpeakEleProfileHeaderView1: UIView, UINavigationControllerDelegate {
    
    @IBOutlet weak var SpeakProfileTitleL: UILabel!
    
    @IBOutlet weak var SpeakProfileIcon: UIImageView!
    @IBOutlet weak var SpeakProfileName: UILabel!
    @IBOutlet weak var SpeakProfileEmailL: UILabel!
    
    @IBOutlet weak var SpeakProfileTopView: UIView!
    
    @IBOutlet weak var SpeakTopConstraint: NSLayoutConstraint!
    @IBOutlet weak var isPayView: UIView!
    
    @IBOutlet weak var ShareBtnssss: UIButton!
    
    class func xib() -> SpeakEleProfileHeaderView1 {
        let xib = UINib(nibName: "SpeakEleProfileHeaderView1", bundle: nil).instantiate(withOwner: nil).first as! SpeakEleProfileHeaderView1
        return xib
    }
    
    var data:SpeakEleProfileModel? {
        didSet {
            SpeakProfileName.text = SpeakElePublicManager.share.userInfo.userName ?? "--"
            SpeakProfileEmailL.text = SpeakElePublicManager.share.userInfo.email ?? "--"
            SpeakProfileTitleL.text = data?.section?.rawValue
            
            SpeakProfileIcon.image = SpeakCache.cache.loadHeader()
        }
    }
    
    override func layoutSubviews() {
        super.layoutSubviews()
        self.layoutIfNeeded()
        isPayView.isHidden = !IAPViewModel.share.isSubscribed
    }
    
    @IBAction func SpeakProfileHeaderTaps(_ sender: Any) {
        let alert = UIAlertController(title: nil, message: nil, preferredStyle: .actionSheet)
        alert.addAction(UIAlertAction(title: "Camera", style: .default, handler: {[weak self] act in
            self?.PhotoOp(0)
        }))
        alert.addAction(UIAlertAction(title: "Photo Album", style: .default, handler: {[weak self] act in
            self?.PhotoOp(1)
        }))
        alert.addAction(UIAlertAction(title: "Cancel", style: .cancel, handler: { act in
            
        }))
        self.responderCtr()?.present(alert, animated: true)
    }
    
    @IBAction func SpeakProfileRemindTaps(_ sender: Any) {
        let vc = SpeakEleLearnReViewCtr()
        vc.show()
    }
    
    @IBAction func SpeakProfileCollect(_ sender: Any) {
        let collect = SpeakEleProfileCollectViewCtr()
        self.responderCtr()?.navigationController?.pushViewController(collect, animated: true)
    }
    
    @IBAction func SpeakProfileGetNowTaps(_ sender: Any) {
        let iap = SpeakEleIAPViewCtr()
        iap.state = .other
        self.responderCtr()?.navigationController?.AnimationState = .present
        self.responderCtr()?.navigationController?.pushViewController(iap, animated: true)
    }
    
    @IBAction func SpeakShare(_ sender: Any) {
        let items: [Any] = [ URL(string: AppStoreShare)! ]
        let shareVc = UIActivityViewController(
            activityItems: items,
            applicationActivities: nil
        )
        self.responderCtr()?.present(shareVc, animated: true)
    }
    
    @IBAction func NameChange(_ sender: Any) {
        let vc = SpeakEleModifyNameViewCtr()
        vc.show(self.responderCtr())
    }
}

extension SpeakEleProfileHeaderView1 : UIImagePickerControllerDelegate {
    
    /// - Parameter state: 0 相机 1 相册
    private func PhotoOp(_ state:Int) -> Void {
        let imagePicker = UIImagePickerController()
        imagePicker.delegate = self
        imagePicker.allowsEditing = false
        if state == 0 {
            imagePicker.sourceType = .camera
        }else{
            imagePicker.sourceType = .photoLibrary
        }
        self.responderCtr()?.present(imagePicker, animated: true)
    }
    
    func imagePickerController(_ picker: UIImagePickerController, didFinishPickingMediaWithInfo info: [UIImagePickerController.InfoKey : Any]) {
        picker.dismiss(animated: true)
        guard let icon:UIImage = info[UIImagePickerController.InfoKey.originalImage] as? UIImage else { return }
        SpeakCache.cache.Save(data: icon.jpegData(compressionQuality: 0.3))
        SpeakProfileIcon.image = icon
    }
    
}
