//
//  SpeakEleProfileHeaderView.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/7/24.
//

import UIKit

class SpeakEleProfileHeaderView: UITableViewHeaderFooterView {

    static let id = "SpeakEleProfileHeaderView"
    
    override func awakeFromNib() {
        super.awakeFromNib()

    }
    
    override init(reuseIdentifier: String?) {
        super.init(reuseIdentifier: reuseIdentifier)
        setuup()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    private func setuup() -> Void {
        header.snp.makeConstraints { make in
            make.left.right.bottom.top.equalToSuperview()
        }
    }
    
    var isFrist:Bool = false {
        didSet {
            self.layoutIfNeeded()
            header.SpeakProfileTopView.isHidden = !isFrist
            header.SpeakTopConstraint.constant = isFrist ? 70 : 10
            header.ShareBtnssss.isHidden = !isFrist
        }
    }
    
    var data:SpeakEleProfileModel? {
        didSet {
            header.data = data
        }
    }
    
    private lazy var header: SpeakEleProfileHeaderView1 = {
        let h = SpeakEleProfileHeaderView1.xib()
        contentView.addSubview(h)
        return h
    }()
}
