//
//  SpeakEleProfileCollectWordCell.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/7/25.
//

import UIKit

class SpeakEleProfileCollectWordCell: UITableViewCell {

    static let id = "SpeakEleProfileCollectWordCell"
    
    // MARK: - ib
    @IBOutlet weak var SpeakCollectWord: UILabel!
    @IBOutlet weak var SpeakCollectWordNav: UILabel!
    @IBOutlet weak var SpeakLineV: UIView!
    
    var isTop = false
    var isBot = false
    
    override func awakeFromNib() {
        super.awakeFromNib()
        self.backgroundColor = .white
        self.selectionStyle = .none
        self.clipsToBounds = true
    }

    override func layoutSubviews() {
        super.layoutSubviews()
        self.layoutIfNeeded()
        SpeakLineV.isHidden = false
        if isBot && isTop {
            self.cornerRect(radius: 16, [.allCorners])
            SpeakLineV.isHidden = true
        }else if isBot {
            SpeakLineV.isHidden = true
            self.cornerRect(radius: 16, [.bottomLeft,.bottomRight])
        }else if isTop {
            self.cornerRect(radius: 16, [.topLeft,.topRight])
        }else{
            self.cornerRect(radius: 0, [.allCorners])
        }
    }
    
    @IBAction func SpeakPlayerWord(_ sender: Any) {
        SpeakSpeechSynthesizer.share.speakText(SpeakCollectWord.text ?? "")
    }
    
    var data:SpeakCollectWordListModel? {
        didSet {
            SpeakCollectWord.text = data?.word
            SpeakCollectWordNav.text = data?.wordTranslate
        }
    }
}
