//
//  SpeakEleProfileCollectCourseCell.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/7/25.
//

import UIKit

class SpeakEleProfileCollectCourseCell: UITableViewCell {

    static let id = "SpeakEleProfileCollectCourseCell"
    
    // MARK: - ib
    @IBOutlet weak var SpeakCollectIcon: UIImageView!
    @IBOutlet weak var SpeakCollectLeason: UILabel!
    @IBOutlet weak var SpeakCollectWordL: UIButton!
    @IBOutlet weak var SpeakCollectGramer: UIButton!
    @IBOutlet weak var SpeakCollectLineV: UIView!
    
    @IBOutlet weak var SpeakCollBtnntnnnn: UIButton!
    
    var isTop = false
    var isBot = false
    
    var data:SpeakCollectLessonListModel? {
        didSet{
            let imgs = lessonImage[safe: (data?.lessonId ?? 0) % 5] ?? .gray
            SpeakCollBtnntnnnn.setImage(UIImage(named: imgs.rawValue), for: .normal)
            SpeakCollBtnntnnnn.setImage(UIImage(named: imgs.rawValue + "-d"), for: .highlighted)
//            SpeakCollectIcon.image = UIImage(named: imgs.rawValue)
            SpeakCollectLeason.text = data?.lessonName
            SpeakCollectWordL.setTitle("\(data?.wordCount ?? 0)Words", for: .normal)
        }
    }
    
    override func awakeFromNib() {
        super.awakeFromNib()
        self.backgroundColor = .white
        self.selectionStyle = .none
        self.clipsToBounds = true
    }
    
    override func layoutSubviews() {
        super.layoutSubviews()
        self.layoutIfNeeded()
        SpeakCollectLineV.isHidden = false
        if isBot && isTop {
            self.cornerRect(radius: 16, [.allCorners])
            SpeakCollectLineV.isHidden = true
        }else if isBot {
            SpeakCollectLineV.isHidden = true
            self.cornerRect(radius: 16, [.bottomLeft,.bottomRight])
        }else if isTop {
            self.cornerRect(radius: 16, [.topLeft,.topRight])
        }else{
            self.cornerRect(radius: 0, [.allCorners])
        }
    }

}
