//
//  SpeakEleProfileCell.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/7/23.
//

import UIKit

class SpeakEleProfileCell: UITableViewCell {

    static let id = "SpeakEleProfileCell"
    
    // MARK: - ib
    @IBOutlet weak var Icont: UIImageView!
    @IBOutlet weak var TitleL: UILabel!
    @IBOutlet weak var SubTitle: UILabel!
    @IBOutlet weak var LineV: UIView!
    
    var isTop:Bool = false
    var isBot:Bool = false
    
    override func awakeFromNib() {
        super.awakeFromNib()
        self.selectionStyle = .none
    }
    
    var data:SpeakEleProfileDescModel? {
        didSet{
            let icon = "icon_\(data?.title?.rawValue ?? "")"
            Icont.image = UIImage(named: icon)
            TitleL.text = data?.title?.rawValue
            if data?.title == .Delete {
                TitleL.textColor = .init(hex: 0xEB3B2F)
            }else{
                TitleL.textColor = .init(hex: 0x000000,alpha: 0.9)
            }
            if data?.title == .TargetLanguage {
                SubTitle.text = SpeakElePublicManager.share.userInfo.targetLanguage
            }else if data?.title == .NativeLanguage {
                SubTitle.text = SpeakElePublicManager.share.userInfo.nativeLanguage
            }else if data?.title == .Interest {
                SubTitle.text = SpeakElePublicManager.share.PublicData.MHobby
            }else if data?.title == .Target {
                SubTitle.text = SpeakElePublicManager.share.PublicData.MStudytime
            }else{
                SubTitle.text = ""
            }
        }
    }
    
    override func layoutSubviews() {
        super.layoutSubviews()
        LineV.isHidden = isBot
        if isTop {
            contentView.cornerRect(radius: 16, [.topLeft,.topRight])
            contentView.addShadow(to: [.top,.left,.right] ,shadowColor: .init(hex: 0x595959) ,shadowOpacity: 0.1 ,shadowRadius: 16 ,shadowSpread: 4)
        }else if isBot {
            contentView.cornerRect(radius: 16, [.bottomLeft,.bottomRight])
            contentView.addShadow(to: [.bottom,.left,.right] ,shadowColor: .init(hex: 0x595959) ,shadowOpacity: 0.1 ,shadowRadius: 16 ,shadowSpread: 4)
        }else{
            contentView.cornerRect(radius: 0, [.bottomLeft,.bottomRight,.topLeft,.topRight])
            contentView.addShadow(to: [.left,.right] ,shadowColor: .init(hex: 0x595959) ,shadowOpacity: 0.1 ,shadowRadius: 16 ,shadowSpread: 4)
        }
    }
    
}
