//
//  SpeakEleProfileModel.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/7/23.
//

import UIKit

enum ProFileInfo : Int {
    case PSwitch
    case PInfo
}

enum SpeakTitleState : String {
    case Language = "Language"
    case Other = "Other"
    case Support = "Support"
    
    case TargetLanguage = "Target Language"
    case NativeLanguage = "Native Language"
    case Learn = "Learn in One's Mother Tongue"
    
    case Interest = "Interest"
    case Target = "Target"
    
    case RateUs = "Rate Us"
    case Restore = "Restore"
    case PrivacyPolicy = "Privacy Policy"
    case Terms = "Terms of Services"
    case Delete = "Delete Account ?"
}

struct SpeakEleProfileModel {
    var section:SpeakTitleState?
    var child:[SpeakEleProfileDescModel]?
}

struct SpeakEleProfileDescModel {
    var title:SpeakTitleState?
    var state:ProFileInfo = .PInfo
}

struct SpeakEleCollectionModel<T:Codable> : Codable {
    
    var list:[T]?
    var total:Int?
    var pageNum:Int?
    var pageSize:Int?
    var totalPages:Int?
    var hasNext:Bool?
    var hasPrevious:Bool?
    
}

struct SpeakCollectLessonListModel : Codable {
    var lessonId:Int?
    var lessonName:String?
    var wordCount:Int?
}


struct SpeakCollectWordListModel : Codable {

    var wordId:Int?
    var word:String?
    var wordTranslate:String?
    
}
