//
//  SpeakEleProfileCollectViewCtr.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/7/25.
//

import UIKit
import MJRefresh


class SpeakEleProfileCollectViewCtr: SpeakEleBaseViewCtr {

    // MARK: - ib
    @IBOutlet var SpeakCollectItems: [UIImageView]!
    @IBOutlet var SpeakCollectNumbers: [UILabel]!
    @IBOutlet weak var SpeakScrollView: UIScrollView!
    @IBOutlet weak var SpeakCourseTab: UITableView!
    @IBOutlet weak var SpeakWordsTab: UITableView!
    
    private let viewModel = SpeakEleProfileNetViewModel()
    private var pageNum = 1
    private var selectIdx = 0 {
        didSet{
            SpeakCollectItems[0].isHidden = selectIdx != 0
            SpeakCollectItems[1].isHidden = selectIdx == 0
            self.loadCours()
            self.loadWords()
        }
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        self.title = "Collect"
        self.view.backgroundColor = .init(hex: 0xF6F7F9)
        SpeakCollectNumbers.forEach({$0.contentInsets = UIEdgeInsets(top: 0, left: 10, bottom: 0, right: 10)})
        SpeakAlertHUD.share.show()
    }

    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        selectIdx = 0
    }
    
    @IBAction func SpeakProfileCollectTaps(_ sender: UIButton) {
        if selectIdx == sender.tag % 10 {
            return
        }
        selectIdx = sender.tag % 10
        UIView.animate(withDuration: 0.25) {
            self.SpeakScrollView.contentOffset = CGPointMake(CGFloat(self.selectIdx) * self.SpeakScrollView.width, 0)
        }
    }
    
    override func setup() {
        SpeakScrollView.delegate = self
        SpeakCourseTab.delegate = self
        SpeakCourseTab.dataSource = self
        SpeakCourseTab.register(UINib(nibName: SpeakEleProfileCollectCourseCell.id, bundle: nil), forCellReuseIdentifier: SpeakEleProfileCollectCourseCell.id)
        SpeakCourseTab.sectionHeaderTopPadding = 0
        SpeakCourseTab.showsVerticalScrollIndicator = false
        SpeakCourseTab.showsHorizontalScrollIndicator = false
        SpeakCourseTab.sectionHeaderHeight = 20
        SpeakCourseTab.mj_header = MJRefreshNormalHeader(refreshingBlock: { [weak self] in
            self?.loadData()
        })
        SpeakCourseTab.mj_footer = MJRefreshAutoNormalFooter(refreshingBlock: { [weak self] in
            self?.loadMore()
        })
        
        SpeakWordsTab.delegate = self
        SpeakWordsTab.dataSource = self
        SpeakWordsTab.register(UINib(nibName: SpeakEleProfileCollectWordCell.id, bundle: nil), forCellReuseIdentifier: SpeakEleProfileCollectWordCell.id)
        SpeakWordsTab.sectionHeaderTopPadding = 0
        SpeakWordsTab.showsVerticalScrollIndicator = false
        SpeakWordsTab.showsHorizontalScrollIndicator = false
        SpeakWordsTab.sectionHeaderHeight = 20
        SpeakWordsTab.mj_header = MJRefreshNormalHeader(refreshingBlock: { [weak self] in
            self?.loadData()
        })
        SpeakWordsTab.mj_footer = MJRefreshAutoNormalFooter(refreshingBlock: { [weak self] in
            self?.loadMore()
        })
    }
    
    var leasonData:[SpeakCollectLessonListModel] = []
    var WordData:[SpeakCollectWordListModel] = []
 
    override func loadData() -> Void {
        pageNum = 1
        if selectIdx == 0 {
            self.loadCours()
        }else{
            self.loadWords()
        }
    }
    
    private func loadCours() -> Void {
        viewModel.collectLessonList(param: ["pageNum":pageNum,"pageSize":20]) { [weak self] (success, data:SpeakEleCollectionModel<SpeakCollectLessonListModel>?) in
            if success {
                let sub = data?.list
                self?.leasonData = sub ?? []
                if (data?.totalPages ?? 0) <= self?.pageNum ?? 0 {
                    self?.SpeakCourseTab.mj_footer?.endRefreshingWithNoMoreData()
                }
                self?.SpeakCollectNumbers.first?.text = "\(data?.total ?? 0)"
            }
            SpeakAlertHUD.share.disMiss()
            self?.SpeakCourseTab.reloadData()
            self?.SpeakCourseTab.mj_header?.endRefreshing()
        }
    }
    
    private func loadWords() -> Void {
        viewModel.collectWordList(param: ["pageNum":pageNum,"pageSize":20]) { [weak self] (success, data:SpeakEleCollectionModel<SpeakCollectWordListModel>?) in
            if success {
                let sub = data?.list
                self?.WordData = sub ?? []
                if (data?.totalPages ?? 0) <= self?.pageNum ?? 0 {
                    self?.SpeakWordsTab.mj_footer?.endRefreshingWithNoMoreData()
                }
                self?.SpeakCollectNumbers.last?.text = "\(data?.total ?? 0)"
            }
            self?.SpeakWordsTab.mj_header?.endRefreshing()
            self?.SpeakWordsTab.reloadData()
        }
    }
    
    private func loadMore() -> Void {
        pageNum += 1
        if selectIdx == 0 {
            viewModel.collectLessonList(param: ["pageNum":pageNum,"pageSize":20]) { [weak self] (success, data:SpeakEleCollectionModel<SpeakCollectLessonListModel>?) in
                if success {
                    let sub = data?.list
                    self?.leasonData = sub ?? []
                    if (data?.totalPages ?? 0) <= self?.pageNum ?? 0 {
                        self?.SpeakCourseTab.mj_footer?.endRefreshingWithNoMoreData()
                    }
                }
                self?.SpeakCourseTab.reloadData()
                self?.SpeakCourseTab.mj_footer?.endRefreshing()
            }
        }else{
            viewModel.collectWordList(param: ["pageNum":pageNum,"pageSize":20]) { [weak self] (success, data:SpeakEleCollectionModel<SpeakCollectWordListModel>?) in
                if success {
                    let sub = data?.list
                    self?.WordData = sub ?? []
                    if (data?.totalPages ?? 0) <= self?.pageNum ?? 0 {
                        self?.SpeakWordsTab.mj_footer?.endRefreshingWithNoMoreData()
                    }
                    
                }
                self?.SpeakWordsTab.mj_footer?.endRefreshing()
                self?.SpeakWordsTab.reloadData()
            }
        }
    }
    
}

extension SpeakEleProfileCollectViewCtr:UIScrollViewDelegate,UITableViewDelegate,UITableViewDataSource {
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        if tableView == SpeakCourseTab {
            return leasonData.count
        }
        return WordData.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        if tableView == SpeakCourseTab {
            let cell = tableView.dequeueReusableCell(withIdentifier: SpeakEleProfileCollectCourseCell.id, for: indexPath) as! SpeakEleProfileCollectCourseCell
            cell.isTop = indexPath.row == 0
            cell.isBot = indexPath.row == leasonData.count - 1
            cell.data = self.leasonData[indexPath.row]
            return cell
        }else{
            let cell = tableView.dequeueReusableCell(withIdentifier: SpeakEleProfileCollectWordCell.id, for: indexPath) as! SpeakEleProfileCollectWordCell
            cell.isTop = indexPath.row == 0
            cell.isBot = indexPath.row == WordData.count - 1
            cell.data = self.WordData[indexPath.row]
            return cell
        }
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        
    }
    
    func scrollViewDidEndDecelerating(_ scrollView: UIScrollView) {
        if scrollView == SpeakScrollView {
            let offsetx = scrollView.contentOffset.x
            selectIdx = Int(round(offsetx / scrollView.width))
        }
    }
    
    func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> UIView? {
        return UIView()
    }
}
