//
//  SpeakPracticeWordView.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/7/23.
//

import UIKit

class SpeakPracticeWordView: UIView {

    
    var SpeakPracticeIcon: UIImageView!
    var SpeakPracticeFavorites: UIButton!
    var SpeakPracticeWord: UILabel!
    var SpeakPracticeLabel: UILabel!
    
    @objc private func FavoritesTaps(_ sender: UIButton) {
        SpeakPracticeFavorites.isSelected = !sender.isSelected
        guard let call = callblack else { return }
        call(sender.isSelected)
    }

    var contentView: UIView?
    private var didLoadNib = false // 新增标志位
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setupFromNib()
    }
    
    func setLabel(_ s:Int) -> Void {
        SpeakPracticeLabel.isHidden = true
        if s == 1 {
            SpeakPracticeLabel.text = "Familar"
            SpeakPracticeLabel.textColor = .init(hex: 0x00BD13)
            SpeakPracticeLabel.borderColor = .init(hex: 0x00BD13)
            SpeakPracticeLabel.isHidden = false
        }else if s == 2 {
            SpeakPracticeLabel.text = "Strange"
            SpeakPracticeLabel.textColor = .init(hex: 0xEB3B2F)
            SpeakPracticeLabel.borderColor = .init(hex: 0xEB3B2F)
            SpeakPracticeLabel.isHidden = false
        }
    }
    
    required init?(coder aDecoder: NSCoder) {
        super.init(coder: aDecoder)
        setupFromNib()
    }
    
    override func layoutSubviews() {
        super.layoutSubviews()
    }
    
    private func setupFromNib() {
        backgroundColor = .brown
        SpeakPracticeIcon = UIImageView()
        SpeakPracticeIcon.contentMode = .scaleAspectFill
        addSubview(SpeakPracticeIcon)
        SpeakPracticeIcon.snp.makeConstraints { make in
            make.left.right.bottom.top.equalToSuperview()
        }
        
        SpeakPracticeFavorites = UIButton(type: .custom)
        SpeakPracticeFavorites.setImage(UIImage(named: "sp-pra-heart"), for: .normal)
        SpeakPracticeFavorites.setImage(UIImage(named: "sp-pra-heart-s"), for: .selected)
        SpeakPracticeFavorites.addTarget(self, action: #selector(FavoritesTaps(_:)), for: .touchUpInside)
        addSubview(SpeakPracticeFavorites)
        SpeakPracticeFavorites.snp.makeConstraints { make in
            make.right.top.equalToSuperview().inset(16)
        }
        
        SpeakPracticeWord = UILabel()
        SpeakPracticeWord.text = "Vitality"
        SpeakPracticeWord.textColor = .white
        SpeakPracticeWord.font = UIFont.montserrat(.medium,size: 32)
        addSubview(SpeakPracticeWord)
        SpeakPracticeWord.snp.makeConstraints { make in
            make.bottom.equalToSuperview().inset(40)
            make.centerX.equalToSuperview()
        }
        
        SpeakPracticeLabel = UILabel()
        SpeakPracticeLabel.font = UIFont.montserrat(.semiBold,size: 18)
        SpeakPracticeLabel.borderWidth = 2
        SpeakPracticeLabel.corners = 4
        SpeakPracticeLabel.textAlignment = .center
        SpeakPracticeLabel.contentInsets = UIEdgeInsets(top: 2, left: 8, bottom: 2, right: 8)
        addSubview(SpeakPracticeLabel)
        SpeakPracticeLabel.snp.makeConstraints { make in
            make.top.left.equalToSuperview().inset(16)
        }
        
    }

    deinit {
        callblack = nil
    }
    
}
