//
//  SpeakPracticeLearnedWCell.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/7/28.
//

import UIKit

class SpeakPracticeLearnedWCell: UITableViewCell {

    static let id = "SpeakPracticeLearnedWCell"
    
    @IBOutlet weak var SpeakPracticeLearnedIcon: UIImageView!
    @IBOutlet weak var SpeakPracticeLearnedName: UILabel!
    @IBOutlet weak var SpeakPracticeLearnedDescp: UILabel!
    @IBOutlet weak var SpeakPracticeLearnedInfo: UIImageView!
    
    @IBOutlet weak var SpeakPracticeRightInFo: UIButton!
    
    override func awakeFromNib() {
        super.awakeFromNib()
    }

    var data:SpeakPracticeLessonModel? {
        didSet{
            
            let d = (data?.lessonId ?? 0) % 5
            let img = lessonImage[safe: d] ?? .gray
            SpeakPracticeLearnedIcon.image = UIImage(named: img.rawValue)
            SpeakPracticeLearnedName.text = data?.lessonName
            SpeakPracticeLearnedDescp.text = "Reviewed \(data?.familiarCount ?? 0)/\(data?.totalWordCount ?? 0)"
            
            let su = (data?.familiarCount ?? 0 >= data?.totalWordCount ?? 0) && (data?.totalWordCount ?? 0 != 0)
            SpeakPracticeLearnedInfo.contentMode = .scaleToFill
            SpeakPracticeLearnedInfo.image = UIImage(named: su ? "icon_huizhang" : "icon_jinduquan")
        }
    }
    
    override func layoutSubviews() {
        super.layoutSubviews()
        self.layoutIfNeeded()
        SpeakPracticeRightInFo.cornerRect(radius: 8, [.topRight,.bottomLeft])
        let su = (data?.familiarCount ?? 0 >= data?.totalWordCount ?? 0) && (data?.totalWordCount ?? 0 != 0)
        if su == false {
            shape.frame = self.SpeakPracticeLearnedInfo.bounds
            let width = self.SpeakPracticeLearnedInfo.width
            let arc = CGFloat(data?.familiarCount ?? 0)/CGFloat(data?.totalWordCount ?? 1) * (Double.pi * 2.0)
            let path = UIBezierPath(arcCenter: CGPoint(x: width/2.0, y: width/2.0), radius: width/2.0-2, startAngle: -Double.pi/2.0, endAngle: -Double.pi/2.0 + arc, clockwise: true)
            shape.path = path.cgPath
            shape.lineWidth = 3
            shape.lineCap = .round
            shape.setNeedsLayout()
        }
    }
    
    private lazy var shape: CAShapeLayer = {
        let s = CAShapeLayer()
        SpeakPracticeLearnedInfo.layer.addSublayer(s)
        s.backgroundColor = UIColor.clear.cgColor
        s.fillColor = UIColor.clear.cgColor
        s.strokeColor = UIColor.init(hex: 0xFFB200).cgColor
        return s
    }()
}
