//
//  SpeakElePracticeReviewFlowLayout.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/7/23.
//

import UIKit

class SpeakElePracticeReviewFlowLayout: UICollectionViewFlowLayout {
    
    override func layoutAttributesForElements(in rect: CGRect) -> [UICollectionViewLayoutAttributes]? {
            guard let collectionView = collectionView else { return nil }
            let count = collectionView.numberOfItems(inSection: 0)
            var attributesArray = [UICollectionViewLayoutAttributes]()
            let commonFrame = CGRect(x: 0, y: 0, width: collectionView.bounds.width, height: collectionView.bounds.height)
            for item in 0..<count {
                let indexPath = IndexPath(item: item, section: 0)
                let attributes = UICollectionViewLayoutAttributes(forCellWith: indexPath)
                attributes.frame = commonFrame
                attributes.zIndex = count - item
                attributesArray.append(attributes)
            }
            return attributesArray
        }
        
        override var collectionViewContentSize: CGSize {
            return collectionView?.bounds.size ?? .zero
        }
        
        override func layoutAttributesForItem(at indexPath: IndexPath) -> UICollectionViewLayoutAttributes? {
            let attributes = UICollectionViewLayoutAttributes(forCellWith: indexPath)
            attributes.frame = CGRect(x: 0, y: 0, width: collectionView?.bounds.width ?? 0, height: collectionView?.bounds.height ?? 0)
            attributes.zIndex = collectionView!.numberOfItems(inSection: indexPath.section) - indexPath.item
            return attributes
        }
}
