//
//  SpeakPracticeWordsListViewCtr.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/7/25.
//

import UIKit

class SpeakPracticeWordsListViewCtr: SpeakEleBaseViewCtr {

    @IBOutlet weak var SpeakWordTotalL: UILabel!
    @IBOutlet weak var SpeakWordTableView: UITableView!
    
    private let viewModel = SpeakPracticeNetViewModel()
    
    var leasionId:Int = 0
    var leasionName:String = ""
    
    override func viewDidLoad() {
        super.viewDidLoad()
        self.view.backgroundColor = .init(hex: 0xF6F7F9)
    }
    
    override func setup() {
        self.title = leasionName
        self.SpeakWordTableView.delegate = self
        self.SpeakWordTableView.dataSource = self
        self.SpeakWordTableView.sectionHeaderTopPadding = 0.1
        self.SpeakWordTableView.sectionHeaderHeight = 12
        self.SpeakWordTableView.sectionFooterHeight = 0.1
        self.SpeakWordTableView.showsVerticalScrollIndicator = false
        self.SpeakWordTableView.showsHorizontalScrollIndicator = false
        self.SpeakWordTableView.register(UINib(nibName: SpeakPracticeWordsListCell.id, bundle: nil), forCellReuseIdentifier: SpeakPracticeWordsListCell.id)
        self.alert.show()
        viewModel.wordMarkStatus(param: ["lessonId":self.leasionId]) {[weak self] (success, data:[SpeakPracticeWordModel]? ) in
            if success {
                self?.datasource = data ?? []
                self?.SpeakWordTotalL.text = "\(data?.count ?? 0) words in total"
            }
            self?.alert.disMiss()
        }
    }
    
    var datasource:[SpeakPracticeWordModel] = [] {
        didSet{
            self.SpeakWordTableView.reloadData()
        }
    }
    
}

extension SpeakPracticeWordsListViewCtr : UITableViewDelegate,UITableViewDataSource {
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withIdentifier: SpeakPracticeWordsListCell.id, for: indexPath) as! SpeakPracticeWordsListCell
        let data = self.datasource[indexPath.section]
        cell.SpeakPracticeWordL.text = data.word
        cell.SpeakPracticeWordSub.text = data.wordTranslate
        cell.SpeakPracticeType.image = UIImage(named: data.markStatus == 1 ? "icon_familar" : (data.markStatus == 2 ?  "icon_strange" : "") )
        return cell
    }
    
    func numberOfSections(in tableView: UITableView) -> Int {
        return datasource.count
    }
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return 1
    }
    
    func tableView(_ tableView: UITableView, viewForFooterInSection section: Int) -> UIView? {
        return UIView()
    }
    
    func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> UIView? {
        return UIView()
    }
}
