//
//  SpeakPracticeLearnedWViewCtr.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/7/28.
//

import UIKit

class SpeakPracticeLearnedWViewCtr: SpeakEleBaseViewCtr {

    @IBOutlet weak var SpeakLearnedWTableView: UITableView!
    
    var data:[SpeakPracticeLessonModel] = []
    
    override func viewDidLoad() {
        super.viewDidLoad()
        self.title = "Learned words"
        self.view.backgroundColor = .init(hex: 0xF6F7F9)
    }
    
    override func setup() {
        SpeakLearnedWTableView.delegate = self
        SpeakLearnedWTableView.dataSource = self
        SpeakLearnedWTableView.sectionHeaderTopPadding = 0
        SpeakLearnedWTableView.sectionHeaderHeight = 13
        SpeakLearnedWTableView.separatorStyle = .none
        SpeakLearnedWTableView.register(UINib(nibName: SpeakPracticeLearnedWCell.id, bundle: nil), forCellReuseIdentifier: SpeakPracticeLearnedWCell.id)
    }
    
    deinit {
        view.callblack = nil
    }
}

extension SpeakPracticeLearnedWViewCtr: UITableViewDelegate,UITableViewDataSource {
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return data.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withIdentifier: SpeakPracticeLearnedWCell.id, for: indexPath) as! SpeakPracticeLearnedWCell
        cell.data = self.data[indexPath.row]
        cell.SpeakPracticeRightInFo.isHidden = indexPath.row != 0
        cell.selectionStyle = .none
        return cell
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        if indexPath.row != 0 {
            let data = self.data[indexPath.row]
            let desc = "Are you sure to review the words in ".attributed().color(.init(hex: 0x000000,alpha: 0.54)).build().combined(with: [(data.lessonName ?? "").attributed().color(.init(hex: 0x3980F6)).build() ])
            let image = lessonImage[safe: ((data.lessonId ?? 0) % 5)] ?? .gray
            let tips = SpeakPublicTipsViewCtr(configs: SpeakPublicTipsViewCtr.PublicTipsModel(icon: UIImage(named: image.rawValue), title: "Switch review content?",  descAttr: desc, sureAction: "Sure",cancel: "Wait a minute"))
            tips.show()
            tips.view.callblack = { [weak self] action in
                if let su = action as? Bool ,
                    su == true {
                    self?.switchLeasion(indexPath.row)
                    guard let call = self?.view.callblack else { return }
                    call(self?.data.first)
                }
            }
        }
    }
    
    func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> UIView? {
        return UIView()
    }
    
    private func switchLeasion(_ index:Int) -> Void {
        if data.count > 1 {
            data.swapAt(0, index)
            self.SpeakLearnedWTableView.reloadData()
        }
    }
    
}
