//
//  SpeakPacticeFinishViewCtr.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/8/4.
//

import UIKit

class SpeakPacticeFinishViewCtr: SpeakEleBaseViewCtr {

    @IBOutlet weak var SpeakFinishAnimationV: UIImageView!
    
    enum SpeakFinishState {
        case pactice
        case other
    }
    
    var data:[SpeakPracticeWordModel] = []
    var wordTm:Int = 0
    var state:SpeakFinishState = .pactice
    
    @IBOutlet var SpeakFinishTLs: [UIButton]!
    @IBOutlet var SpeakFinishSubTLs: [UIButton]!
    
    @IBOutlet weak var SpeakIconAniMation: UIImageView!
    @IBOutlet var SpeakAnimations: [UIView]!
    @IBOutlet weak var SpeakTopImageCenterX: NSLayoutConstraint!
    
    override func viewDidLoad() {
        super.viewDidLoad()
        SpeakTopImageCenterX.constant = Dev.screenW
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        titleView.isHidden = true
        SpeakFinishTLs.forEach({$0.isSelected = (state != SpeakFinishState.pactice) })
        SpeakFinishSubTLs.forEach({ $0.isSelected = (state != SpeakFinishState.pactice)})
        self.view.layoutIfNeeded()
        setData()
        
        rotain()
    }

    private func rotain() -> Void {
        let rotationAnimation = CABasicAnimation(keyPath: "transform.rotation")
        rotationAnimation.fromValue = 0.0
        rotationAnimation.toValue = Double.pi * 2.0
        rotationAnimation.duration = 5.0
        rotationAnimation.repeatCount = .infinity
        SpeakIconAniMation.layer.add(rotationAnimation, forKey: nil)
    }
    
    private func getTimeForamt(_ time:Int) -> String {
        let m = time / 60;
        let sec = time % 60;
        return String(format: "%02d:%02d", m,sec)
    }
    
    private func setData() -> Void {
        if state == .pactice {
            SpeakFinishSubTLs[0].setTitle("\(self.data.count) Words", for: .normal)
            let dc = self.data.filter({$0.markStatus == 1})
            SpeakFinishSubTLs[1].setTitle("\(dc.count) Words", for: .normal)
            let strog = self.data.filter({$0.markStatus == 2})
            SpeakFinishSubTLs[2].setTitle("\(strog.count) Words", for: .normal)
            SpeakFinishSubTLs[3].setTitle("\(getTimeForamt(wordTm))", for: .normal)
        } else {
            SpeakFinishSubTLs[0].setTitle("\(self.data.count) Words", for: .normal)
            let dc = self.data.filter({$0.markStatus == 1})
            SpeakFinishSubTLs[1].setTitle("\(dc.count) Items", for: .normal)
            let strog = self.data.filter({$0.markStatus == 2})
            SpeakFinishSubTLs[2].setTitle("\(strog.count) Times", for: .normal)
            SpeakFinishSubTLs[3].setTitle("\(getTimeForamt(wordTm))", for: .normal)
        }
        StartAnimation()
    }
    
    private func StartAnimation() -> Void {
        self.view.setNeedsDisplay()
        UIView.animate(withDuration: 0.5, delay: 0.5, usingSpringWithDamping: 0.7, initialSpringVelocity: 1 ,options: .curveEaseOut) {
            self.SpeakTopImageCenterX.constant = 0
            self.view.layoutIfNeeded()
        }
        DispatchQueue.main.asyncAfter(deadline: .now() + 1, execute: {
            self.SpeakFinishAnimationV.loadGif(name: "奖杯礼花_30_iSpt",oftype: "png" ,repeatCount: 1)
        })
        for (i,v) in SpeakAnimations.enumerated() {
            UIView.animate(withDuration: 0.7, delay: 1.1+0.75*Double(i)) {
                v.alpha = 1
            }
        }
    }
    
    @IBAction func SpeakContineTaps(_ sender: Any) {
        self.navigationController?.popToRootViewController(animated: true)
    }
    
    override func PopViewCtr() {
        self.navigationController?.popToRootViewController(animated: true)
    }
    
}
