//
//  SpeakHomeViewModel.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/8/5.
//

import UIKit

class SpeakHomeViewModel: NSObject {

    var dateUpdateComplate:((Any)->Void) = { data in}
    private let net = SpeakNetHomeViewModel()
    private var AIConfigs:[SpeakAIserConfigsModel] = []
    
    var AllSsons:[SpeakHomeLessonModel] = [] {
        didSet{
            dateUpdateComplate(AllSsons)
        }
    }
    
    func fetchSesson() -> Void {
        net.SpeakAllLessons {[weak self] (su, data:[SpeakHomeLessonModel]?) in
            if su {
                self?.AllSsons = data ?? []
            }
        }
    }
    
    func fetchUserInfo() -> Void {
        net.getUserInfo(param: [:]) {(su, data:UserMode?) in
            if su {
                SpeakElePublicManager.share.userInfo.assign(from: data)
                NotificationCenter.default.post(name: NSNotification.Name.UserInfoUpdate, object: nil)
            }
        }
    }
    
    func SignUp(data:String ,complate:@escaping ((Bool)->Void)) -> Void {
        net.signUp(param: ["date":data]) { (su, data:Bool?) in
            complate(su)
        }
    }
    
    func fetchLeasson(leassonId:Int ,complate:@escaping((_ data:SpeakLessonDescpModel?)->Void)) -> Void {
        net.SpeakGetLessonById(param: ["lessonId": leassonId]) { (su, data:SpeakLessonDescpModel?) in
            if su {
                if let s = data {
                    complate(s)
                }
            }
        }
    }
    
    @discardableResult
    func AIser() -> [SpeakAIserConfigsModel] {
        if AIConfigs.count > 0 {
            return AIConfigs
        }
        AIConfigs = [
            SpeakAIserConfigsModel(name: "Claire", label: ["Biz","Exam"], nation: "🇩🇪 Germany · Berlin", descption: "Sharp and efficient—focuses on clear, useful skills, with a professional, no-fuss attitude.", voiceId: "EXAVITQu4vr4xnSDxMaL"),
            SpeakAIserConfigsModel(name: "Oliver", label: ["Pron","Listen"], nation: "🇨🇦 Canada · Vancouver", descption: "Gentle and detail-focused—takes time to fix small mistakes, with a calm, encouraging tone.", voiceId: "CYw3kZ02Hs0563khs1Fj"),
            SpeakAIserConfigsModel(name: "Skylar", label: ["Fun","Teens"], nation: "🇳🇿 New Zealand · Auckland", descption: "Energetic and playful—turns lessons into games, keeping teens engaged with a lively, friendly style.", voiceId: "21m00Tcm4TlvDq8ikWAM"),
            SpeakAIserConfigsModel(name: "Ethan", label: ["Daily","Work"], nation: "🇺🇸 USA · California", descption: "Cheerful and practical—makes everyday English feel easy, like chatting with a friendly, upbeat pal.", voiceId: "5Q0t7uMcjvnagumLfvZi"),
            SpeakAIserConfigsModel(name: "Dylan", label: ["Slang","Pop"], nation: "🇦🇺 Australia · Sydney", descption: "Cool and laid-back—teaches in a casual, trendy way, making learning feel like hanging out.", voiceId: "CwhRBWXzGAHq8TQ4Fs17"),
            SpeakAIserConfigsModel(name: "Betty", label: ["Basic","Star"], nation: "🇨🇳 China · Shanghai", descption: "Kind and steady—guides beginners gently, with a nurturing, reassuring approach.", voiceId: "9BWtsMINqrJLrRacOk9x"),
            SpeakAIserConfigsModel(name: "Julian", label: ["Drama","Lit"], nation: "🇬🇧 UK · London", descption: "Elegant and patient—turns language learning into lively, story-like fun with a warm, classic vibe.", voiceId: "D38z5RcWu1voky8WS1ja"),
            SpeakAIserConfigsModel(name: "Poppy", label: ["Rhymes","Kids"], nation: "🇮🇪 Ireland · Dublin", descption: "Sweet and warm—makes learning cozy and joyful, perfect for little ones with a soft, playful tone.", voiceId: "AZnzlk1XvdvUeBnXmlld")
            
        ]
        return AIConfigs
    }
}


class speakSignListViewModel : NSObject {
    static let share = speakSignListViewModel()
    private let net = SpeakNetHomeViewModel()
    private override init() {}
    
    var signList:[String:[SignListModel]]?
    
    func fetchSign( complate:@escaping(()->Void)) -> Void {
        net.signList(param: [:]) {[weak self] (su, data:[String:[SignListModel]]? ) in
            if su {
                self?.signList = data
                complate()
            }
        }
    }
    
}

struct SignListModel:Codable {
    var id:Int?
    var userId:Int?
    var signDate:String?
    var createdAt:String?
}


struct SpeakAIserConfigsModel {
    var name:String/* = ""*/
    var label:[String]/* = []*/
    var nation:String/* = ""*/
    var descption:String/* = ""*/
    var voiceId:String/* = ""*/
    init(name: String, label: [String], nation: String, descption: String, voiceId: String) {
        self.name = name
        self.label = label
        self.nation = nation
        self.descption = descption
        self.voiceId = voiceId
    }
}
