//
//  SpeakEleLessionView.swift
//  SpeakEasyLearnEnglish
//
//  Created by mac on 2025/7/15.
//

import UIKit

enum buttonColorType : String {
    case red = "sp-home-red"
    case blue = "sp-home-blue"
    case yellow = "sp-home-xyellow"
    case green = "sp-home-green"
    case gray = "sp-home-gray"
    case orange = "sp-home-orange"
}


class SpeakEleLessionView: UIView {

    var selectIdx = 0
    var isStart = false {
        didSet{
            self.layoutIfNeeded()
            DispatchQueue.main.asyncAfter(deadline: .now()+1) {
                self.SpeakLessionStart.isHidden = self.isStart
            }
            if isStart == false {
                self.startUpDownAnimationWithCoreAnimation()
            }else{
                self.stopCoreAnimation()
            }
        }
    }
    
    private lazy var SpeakLessionStart: UIImageView = {
        let start = UIImageView()
        start.isHidden = true
        self.addSubview(start)
        return start
    }()
    
    private lazy var button: UIButton = {
       let button = UIButton.init(type: .custom)
        button.addTarget(self, action: #selector(ClickTaps), for: .touchUpInside)
       return button
   }()
    
    private lazy var backView: UIView = {
       let bView = UIView()
        bView.backgroundColor = .white
       return bView
   }()
    
    private lazy var nameLb: UILabel = {
       let nlb = UILabel()
        nlb.font =  UIFont.montserrat(.medium ,size: 14)
        nlb.textColor = .init(hex: 0x000000 ,alpha: 0.9)
        nlb.text = "Music Prefences"
        nlb.numberOfLines = 0
        nlb.textAlignment = .center
       return nlb
   }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
   
        self.isUserInteractionEnabled = true
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    @objc private func ClickTaps() -> Void {
        guard let call = callblack else { return }
        call(data)
    }
    
    var data:SpeakHomeLessonModel? {
        didSet{
            let imgs = lessonImage[safe: (data?.lessonId ?? 0) % 5] ?? .gray
            if (data?.isLocked == true){
                button.setBackgroundImage(UIImage(named: imgs.rawValue + "-g"), for: .normal)
                button.setBackgroundImage(UIImage(named: imgs.rawValue + "-g-d"), for: .highlighted)
            }else{
                button.setBackgroundImage(UIImage(named: imgs.rawValue), for: .normal)
                button.setBackgroundImage(UIImage(named: imgs.rawValue + "-d"), for: .highlighted)
            }
            nameLb.text = data?.lessonName ?? ""
            SpeakLessionStart.image = UIImage(named: "sp-home-Start-" + "\((data?.lessonId ?? 0) % 5)"  )
        }
    }

    private func startUpDownAnimationWithCoreAnimation() {
        self.stopCoreAnimation()
        let animation = CABasicAnimation(keyPath: "position.y")
        animation.fromValue = SpeakLessionStart.center.y
        animation.toValue = SpeakLessionStart.center.y + 10
        animation.duration = 1
        animation.autoreverses = true
        animation.repeatCount = .infinity
        animation.timingFunction = CAMediaTimingFunction(name: .easeInEaseOut)
        SpeakLessionStart.layer.add(animation, forKey: "upDownAnimation")
    }
    
    private func stopCoreAnimation() {
        SpeakLessionStart.layer.removeAnimation(forKey: "upDownAnimation")
    }
    
    private func setupUI() {
        self.addSubview(backView)
        backView.addSubview(button)
        self.addSubview(nameLb)
        backView.snp.makeConstraints { make in
           make.top.left.right.bottom.equalTo(0)
        }
        nameLb.snp.makeConstraints { make in
            make.top.equalTo(backView.snp.bottom).offset(3)
            make.left.right.equalTo(0)
        }
        button.snp.makeConstraints { make in
            make.bottom.left.right.equalToSuperview().inset(9)
        }
        SpeakLessionStart.snp.makeConstraints { make in
           make.bottom.equalTo(self.button.snp.top).offset(5.adapterH())
           make.centerX.equalToSuperview()
        }
    }
    
    override func layoutSubviews() {
        super.layoutSubviews()
        self.layoutIfNeeded()
        backView.corners = backView.height/2.0
        backView.borderWidth = 4
        backView.borderColor = UIColor.init(with: "#000000", alpha: 0.08)
    }

}
