//
//  SpeakChangeStuLanguesView.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/8/20.
//

import UIKit

class SpeakChangeStuLanguesView: UIView {

    @IBOutlet weak var SpeakChangeContentV: UIView!
    
    @IBOutlet var SpeakChangeBtns: [UIButton]!
    @IBOutlet var SpeakInfos: [UIButton]!
    
    var selectIdx:Int = 0 {
        didSet{
            SpeakChangeBtns.forEach({$0.isSelected = false})
            SpeakInfos.forEach({$0.isSelected = false})
            SpeakChangeBtns[selectIdx].isSelected = true
            SpeakInfos[selectIdx].isSelected = true
        }
    }
    
    class func xib() -> SpeakChangeStuLanguesView {
        let nib = UINib(nibName: "SpeakChangeStuLanguesView", bundle: nil).instantiate(withOwner: nil).first as! SpeakChangeStuLanguesView
        return nib
    }
    
    func show() -> Void  {
        UIView.animate(withDuration: 0.25) {
            self.frame = CGRectMake(0, 0, Dev.screenW, Dev.screenH)
        } completion: { su in
            
        }
    }

    func hide() -> Void {
        UIView.animate(withDuration: 0.25) {
            self.frame = CGRectMake(0, -Dev.screenH, Dev.screenW, Dev.screenH)
        } completion: { su in
            
        }
    }
    
    override func layoutSubviews() {
        super.layoutSubviews()
        self.layoutIfNeeded()
        SpeakChangeContentV.cornerRect(radius: 16, [.bottomLeft,.bottomRight])
        SpeakChangeBtns.forEach { btn in
            btn.setBackgroundImage(UIColor.white.generate(), for: .normal)
            btn.setBackgroundImage(UIColor.init(hex: 0xF2F7FF).generate(), for: .highlighted)
            btn.setBackgroundImage(UIColor.init(hex: 0xF2F7FF).generate(), for: .selected)
            btn.cornerRect(radius: 16, [.bottomLeft,.bottomRight])
            btn.addTarget(self, action: #selector(TouchDown(_:)), for: .touchDown)
            btn.addTarget(self, action: #selector(TouchUp(_:)), for: .touchUpOutside)
            btn.addTarget(self, action: #selector(TouchUp(_:)), for: .touchCancel)
        }
    }
    
    @objc func TouchDown(_ sender:UIButton) -> Void {
        if sender == SpeakChangeBtns.first {
            SpeakInfos[0].isSelected = true
        }else{
            SpeakInfos[1].isSelected = true
        }
    }
    
    @objc func TouchUp(_ sender:UIButton) -> Void {
        if sender == SpeakChangeBtns.first {
            SpeakInfos[0].isSelected = false
        }else{
            SpeakInfos[1].isSelected = false
        }
    }
    
    @IBAction func TOIjkjdklsf(_ sender: UIButton) {
        if !sender.isSelected {
            SpeakCache.cache.SaveModel(cache: SpeakPracticeLesLocalModel(lesson: [] ,select: 0), state: .PracticeCache, name: "Lesson")
            if let call = callblack {
                call( sender == SpeakChangeBtns.first ? 0 : 1)
            }
            self.hide()
        }
    }
    
    override func hitTest(_ point: CGPoint, with event: UIEvent?) -> UIView? {
        let view = super.hitTest(point, with: event)
        if SpeakChangeContentV.frame.contains(point) {
            return view
        }
        self.hide()
        return nil
    }
    
    deinit {
        callblack = nil
    }
}
