//
//  SpeakChangeAITableViewCell.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/7/30.
//

import UIKit

class SpeakChangeAITableViewCell: UITableViewCell {

    static let id = "SpeakChangeAITableViewCell"
    
    
    @IBOutlet weak var SpeakAIHeaderIcon: UIImageView!
    @IBOutlet weak var SpeakAINameL: UILabel!
    @IBOutlet weak var SpeakAIDescriptionL: UILabel!
    
    private var audioData:Data = Data()
    
    @IBOutlet var SpeakLabels: [UIButton]!
    @IBOutlet weak var Native: UIButton!
    
    var data:SpeakAIserConfigsModel? {
        didSet {
            let icon = "img_" + (data?.name.lowercased() ?? "")
            SpeakAIHeaderIcon.image = UIImage(named: icon)
            SpeakAINameL.text = data?.name
            SpeakAIDescriptionL.text = data?.descption
            for (i,v) in (data?.label ?? []).enumerated() {
                let but = SpeakLabels[safe:i]
                let img = "icon_" + v.lowercased()
                but?.setImage(UIImage(named: img), for: .normal)
                but?.setTitle(v, for: .normal)
            }
            Native.setTitle(data?.nation, for: .normal)
            guard let path = Bundle.main.path(forResource: data?.name, ofType: ".mp3")
                   else {
                return
            }
            let url = URL(fileURLWithPath: path)
            do{
                audioData = try Data(contentsOf: url)
            }catch{}
        }
    }
    
    override func awakeFromNib() {
        super.awakeFromNib()
    }
    
    @IBAction func SpeakAITestTaps(_ sender: Any) {
        guard let path = Bundle.main.path(forResource: data?.name, ofType: ".mp3")
               else {
            return
        }
        let url = URL(fileURLWithPath: path)
        do{
            audioData = try Data(contentsOf: url)
            AudioPlayerManager.shared.setupAudioPlayer(with: audioData)
        }catch{}
//        guard let call = self.callblack else { return }
//        call("")
    }
    
    deinit {
        self.callblack = nil
    }
}
