//
//  SpeakTipssssssViewCtr.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/8/18.
//

import UIKit

class SpeakTipssssssViewCtr: UIViewController {

    var data : SpeakLessonDescpModel?
    
    @IBOutlet weak var SpeakTipTopContentV: UIView!
    @IBOutlet weak var SpeakTipIcons: UIImageView!
    @IBOutlet weak var SpeakisCollectIcon: UIButton!
    @IBOutlet weak var SpeakLessaL: UILabel!
    @IBOutlet weak var SpeakLessDescp: UILabel!
    @IBOutlet weak var SpeakTipsTypes: UIButton!
    
    @IBOutlet weak var SpeakSoundSwitch: UISwitch!
    @IBOutlet weak var Gammer: UILabel!
    @IBOutlet weak var SpeakWordCollect: UICollectionView!
    
    private let HomeViewModel = SpeakHomeViewModel()
    
    @IBOutlet weak var contentViewBottom: NSLayoutConstraint!
    
    
    let viewModel = SpeakPracticeNetViewModel()
    let ProviewModel = SpeakEleProfileNetViewModel()
    
    var WordData:[SpeakTipssssssMode] = []
    
    override func viewDidLoad() {
        super.viewDidLoad()
        SpeakSoundSwitch.isOn = false
        contentViewBottom.constant = Dev.screenH
    }

    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        self.view.layoutIfNeeded()
        let ta = data?.vocabularyList?.components(separatedBy: ",") ?? []
        
        HomeViewModel.fetchLeasson(leassonId: data?.id ?? 0) {[weak self] fetchData in
            self?.data?.isCollect = fetchData?.isCollect
            self?.SpeakisCollectIcon.isSelected = fetchData?.isCollect ?? false
        }
        
        for (i,v) in ta.enumerated() {
            var mode = SpeakTipssssssMode(work: v)
            WordData.append(mode)
            DispatchQueue.global().async {
                self.viewModel.cardTranslate(param: ["word":v]) {[weak self] (su, data:SpeakPracticeWordDetailModel?) in
                    if su {
                        mode.translation = data?.translation ?? ""
                        self?.WordData[i] = mode
                        if let cell = self?.SpeakWordCollect.cellForItem(at: IndexPath(row: i, section: 0)) as? SpeakTipssssssViewCell{
                            cell.data = mode
                        }
                    }
                }
            }
        }
        setup()
        let lessonLevel = Int(data?.lessonLevel ?? "1") ?? 1
        if lessonLevel < 3 {
            SpeakTipsTypes.setTitle("Simple", for: .normal)
        }else if lessonLevel < 5 {
            SpeakTipsTypes.setTitle("Medium", for: .normal)
        }else{
            SpeakTipsTypes.setTitle("Difficult", for: .normal)
        }
        self.view.setNeedsDisplay()
        DispatchQueue.main.async {
            UIView.animate(withDuration: 0.25) {
                self.contentViewBottom.constant = 10
                self.view.layoutIfNeeded()
            }
        }
    }
    
    private func setup() -> Void {
        let imgs = lessonImage[safe: (data?.id ?? 0) % 5] ?? .gray
        SpeakTipIcons.image = UIImage(named: imgs.rawValue)
        SpeakLessaL.text = data?.lessonKey
        SpeakLessDescp.text = data?.description
        SpeakisCollectIcon.isSelected = data?.isCollect ?? false
        Gammer.text = data?.grammarList
        SpeakWordCollect.showsVerticalScrollIndicator = false
        SpeakWordCollect.showsHorizontalScrollIndicator = false
        SpeakWordCollect.delegate = self
        SpeakWordCollect.dataSource = self
        SpeakWordCollect.register(UINib(nibName: SpeakTipssssssViewCell.id, bundle: nil), forCellWithReuseIdentifier: SpeakTipssssssViewCell.id)
    }
    
    override func viewDidLayoutSubviews() {
        super.viewDidLayoutSubviews()
        self.view.layoutIfNeeded()
        SpeakTipTopContentV.gradient(colors: [.init(hex: 0x87D1FF) ,.init(hex: 0x87D1FF) ,.init(hex: 0x4D93FF)] ,direction: .leftToRight, cornerRadius: 16)
        SpeakTipsTypes.corners = SpeakTipsTypes.height / 2.0
    }
    
    @IBAction func SpeakCollectTaps(_ sender: UIButton) {
        sender.isSelected = !sender.isSelected
        ProviewModel.collect(param: ["businessId":Int(data?.id ?? 0),
                                     "type":1,
                                     "isCollect":!sender.isSelected]) { (su, data:SpeakNetBaseDeflutMode?) in
            if su {
                
            }
        }
    }
    
    @IBAction func SpeakTipsCloseTaps(_ sender: Any) {
        if let call = self.view.callblack {
            call("")
        }
        self.dismiss(animated: true)
    }
    
    @IBAction func SpeakStartTap(_ sender: Any) {
        if let call = self.view.callblack {
            self.dismiss(animated: true) {
                call(self.SpeakSoundSwitch.isOn)
            }
            return
        }
        self.dismiss(animated: true) {}
    }
    
    deinit {
        self.view.callblack = nil
    }
    
}

extension SpeakTipssssssViewCtr : UICollectionViewDelegate,UICollectionViewDataSource,UICollectionViewDelegateFlowLayout {
    
    func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        return WordData.count
    }
    
    func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
        let cell = collectionView.dequeueReusableCell(withReuseIdentifier: SpeakTipssssssViewCell.id, for: indexPath) as! SpeakTipssssssViewCell
        cell.data = self.WordData[indexPath.row]
        return cell
    }
    
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, sizeForItemAt indexPath: IndexPath) -> CGSize {
        return CGSize(width: 140, height: collectionView.height)
    }
}


struct SpeakTipssssssMode:Codable {
    var work:String?
    var translation:String?
}
