//
//  SpeakChangeAIViewCtr.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/7/30.
//

import UIKit

class SpeakChangeAIViewCtr: SpeakEleBaseViewCtr {

    @IBOutlet weak var SpeakContentV: UIView!
    @IBOutlet weak var SpeakChangeAITableView: UITableView!
    private let viewModel = SpeakHomeViewModel()
    
    @IBOutlet weak var SpeakBottomConst: NSLayoutConstraint!
    
    @IBOutlet weak var SpeakTTTTTTT: UIView!
    
    override func viewDidLoad() {
        super.viewDidLoad()
        SpeakBottomConst.constant = -Dev.screenH
        self.view.backgroundColor = .init(hex: 0x000000,alpha: 0.8)
        AISer = viewModel.AIser()
        self.SpeakTTTTTTT.gesture(target: self, class: UITapGestureRecognizer.self, selector: #selector(cloassssssss(_:)))
    }
    
    @objc func cloassssssss(_ res:UIGestureRecognizer) -> Void {
        self.dismiss(animated: true)
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        titleView.isHidden = true
        self.view.layoutIfNeeded()
        self.view.setNeedsDisplay()
        DispatchQueue.main.async {
            if self.SpeakBottomConst.constant != 0 {
                self.SpeakChangeAITableView.reloadData()
                UIView.animate(withDuration: 0.25) {
                    self.SpeakBottomConst.constant = 0
                    self.view.layoutIfNeeded()
                }
            }
        }
    }

    override func setup() {
        SpeakContentV.backgroundColor = .init(hex: 0xF6F7F9)
        SpeakChangeAITableView.dataSource = self
        SpeakChangeAITableView.delegate = self
        SpeakChangeAITableView.sectionHeaderTopPadding = 0
        SpeakChangeAITableView.sectionHeaderHeight = 0.01
        SpeakChangeAITableView.sectionFooterHeight = 16
        SpeakChangeAITableView.showsVerticalScrollIndicator = false
        SpeakChangeAITableView.showsHorizontalScrollIndicator = false
        SpeakChangeAITableView.register(UINib(nibName: SpeakChangeAITableViewCell.id, bundle: nil), forCellReuseIdentifier: SpeakChangeAITableViewCell.id)
    }
    
    @IBAction func SpeakChangeAICloseTaps(_ sender: Any) {
        self.dismiss(animated: true)
    }
    
    override func viewDidLayoutSubviews() {
        super.viewDidLayoutSubviews()
        self.view.layoutIfNeeded()
        SpeakContentV.cornerRect(radius: 16, [.topLeft,.topRight])
    }
    
    private var AISer:[SpeakAIserConfigsModel] = []
    
    deinit {
        self.view.callblack = nil
    }
}

extension SpeakChangeAIViewCtr : UITableViewDelegate , UITableViewDataSource {
    
    func numberOfSections(in tableView: UITableView) -> Int {
        return AISer.count
    }
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return 1
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withIdentifier: SpeakChangeAITableViewCell.id, for: indexPath) as! SpeakChangeAITableViewCell
        cell.data = self.AISer[indexPath.section]
        cell.selectionStyle = .none
        return cell
    }
 
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        let vc = SpeakChangeAIDescViewCtr()
        vc.data = self.AISer[indexPath.section]
        vc.indexPaat = indexPath.section
        vc.view.callblack = { [weak self] t in
            SpeakElePublicManager.share.PublicData.AIerIndex = indexPath.section
            self?.view.callblack?("")
        }
        self.navigationController?.pushViewController(vc, animated: true)
    }
    
    func tableView(_ tableView: UITableView, viewForFooterInSection section: Int) -> UIView? {
        return UIView()
    }
    
    func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> UIView? {
        return UIView()
    }
    
    
}
