//
//  SpeakChangeAIDescViewCtr.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/7/30.
//

import UIKit

class SpeakChangeAIDescViewCtr: SpeakEleBaseViewCtr {

    @IBOutlet weak var SpeakContentV: UIView!
    @IBOutlet weak var SpeakAIBg: UIImageView!
    @IBOutlet weak var SpeakAIDescriptionL: UILabel!
    @IBOutlet weak var SpeakAIName: UILabel!
    
    var data:SpeakAIserConfigsModel?
    
    private var audioData:Data?
    private var player = SpeakVideoPlayer()
    var indexPaat:Int = 0
    
    override func viewDidLoad() {
        super.viewDidLoad()
        player.loadVideo(state: .none, indexPaat)
    }
    
    override func setup() {
        titleView.backgroundColor = .clear
        SpeakAIName.text = data?.name
        SpeakAIDescriptionL.text = data?.descption
        guard let path = Bundle.main.path(forResource: data?.name, ofType: ".mp3")
               else {
            return
        }
        let url = URL(fileURLWithPath: path)
        do{
            audioData = try Data(contentsOf: url)
        }catch{}
        if let bg = player.SpeakPlayerLayer {
            SpeakAIBg.layer.addSublayer(bg)
        }
    }

    @IBAction func closeTaps() -> Void {
        if let call = view.callblack {
            call("")
        }
        self.navigationController?.viewControllers.first?.dismiss(animated: true)
    }
    
    @IBAction func SpeakPlayVoice(_ sender: Any) {
        if let audio = audioData {
            AudioPlayerManager.shared.setupAudioPlayer(with: audio)
        }
    }
    
    override func viewDidLayoutSubviews() {
        super.viewDidLayoutSubviews()
        self.view.layoutIfNeeded()
        self.SpeakContentV.cornerRect(radius: 16, [.topLeft,.topRight])
        player.SpeakPlayerLayer?.frame = SpeakAIBg.bounds
        player.play()
    }

    deinit {
        view.callblack = nil
    }
}
