//
//  SpeakUserNetViewModel.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/7/21.
//

import UIKit
import Moya


class SpeakUserNetViewModel: NetworkUtil<UserAPI> {

    func logion<T:Codable>(param:[String:Any], response:@escaping((Bool,T?)->Void)) -> Void {
        self.alert.show()
        self.request(.login(param)) { (result: Result<SpeakNetBaseMode<T>, Error>) in
            switch result {
            case .success(let res):
                response(res.status == 200,res.result?.data)
                if res.status != 200 {
                    SpWindow.rootViewController?.Alert(message: res.msg ?? "" ,afterClose: 1.5)
                }
                break
            case .failure(_):
                response(false,nil)
                break
            }
            self.alert.disMiss()
        }
    }
    
    func forgot(param:[String:String] , response:@escaping((Bool)->Void)) -> Void {
        self.alert.show()
        self.request(.forgot(param)) { (result: Result<SpeakNetBaseMode<SpeakNetBaseDeflutMode>, Error>) in
            switch result {
            case .success(let res):
                response(res.status == 200)
                if res.status != 200 {
                    SpWindow.rootViewController?.Alert(message: res.msg ?? "" ,afterClose: 1.5)
                }
                break
            case .failure(_):
                response(false)
                break
            }
            self.alert.disMiss()
        }
    }
    
    func update(param:[String:Any] , response:@escaping((Bool)->Void)) -> Void {
        self.request(.userUpdate(param)) { (result: Result<SpeakNetBaseMode<SpeakNetBaseDeflutMode>, Error>) in
            switch result {
            case .success(let res):
                response(res.status == 200)
                break
            case .failure(_):
                response(false)
                break
            }
        }
    }
    
    func SpeakIapConfigs( response:@escaping((IAPConfigsModel?)->Void) ) -> Void {
        self.request(.configs) { (data:Result<SpeakNetBaseMode<IAPConfigsModel>, Error>) in
            switch data {
            case .success(let res):
                if res.status == 200 {
                    response(res.result?.data)
                }
                break
            case .failure(_):
                break
            }
        }
    }
    
}

enum UserAPI : BaseTargetType {
    case login([String:Any])
    case forgot([String:String])
    case userUpdate([String:Any])
    case configs
}

extension UserAPI {
    
    var baseURL: URL {
        return URL(string: "https://feedapihk.zhangxinhulian.com")!
    }
    
    var path: String {
        switch self {
        case .login:
            return "/api/learn/user/login"
        case .forgot:
            return "/api/learn/user/resetSendLink"
        case .userUpdate:
            return "/api/learn/user/update"
        case .configs:
            return "/api/learn/getSpeakPayConfig"
        }
    }
    
    var method: Moya.Method {
        switch self {
        case .login,.userUpdate:
            return .post
        case .forgot ,.configs:
            return .get
        }
    }
    
    var task: Task {
        switch self {
        case .login(let param):
            do {
                let pramdata = try JSONSerialization.data(withJSONObject: param)
                return .requestCompositeData(bodyData: pramdata, urlParameters: param)
            }catch{
                return .requestParameters(parameters: param, encoding: URLEncoding.httpBody)
            }
        case .forgot(let param):
            return .requestParameters(parameters: param, encoding: URLEncoding.default)
        case .userUpdate(let param):
            do {
                let pramdata = try JSONSerialization.data(withJSONObject: param)
                return .requestCompositeData(bodyData: pramdata, urlParameters: param)
            }catch{
                return .requestParameters(parameters: param, encoding: URLEncoding.httpBody)
            }
        case .configs:
            return .requestParameters(parameters: [:], encoding: URLEncoding.default)
        }
    }
    
    var headers: [String: String]? {
        switch self {
        case .login , .forgot ,.configs:
            return ["Content-Type": "application/json"]
        default:
            return ["Content-Type": "application/json",
                    "Authorization":SpeakElePublicManager.share.userInfo.token ?? ""]
        }
    }
}
