//
//  SpeakProgressNetViewModel.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/7/29.
//

import UIKit
import Moya


class SpeakProgressNetViewModel: NetworkUtil<SpeakProgressAPI> {
    func leassionWord<T:Codable>( response:@escaping((Bool,T?)->Void)) -> Void {
        self.request(.wordCount) { (result: Result<SpeakNetBaseMode<T>, Error>) in
            switch result {
            case .success(let res):
                response(res.status == 200,res.result?.data)
                if res.status != 200 {
                    SpWindow.rootViewController?.Alert(message: res.msg ?? "" ,afterClose: 1.5)
                }
                break
            case .failure(let error):
                Print(error.localizedDescription)
                response(false,nil)
                break
            }
        }
    }
    
    func historyRecord<T:Codable>( response:@escaping((Bool,T?)->Void)) -> Void {
        self.request(.historyRecord) { (result: Result<SpeakNetBaseMode<T>, Error>) in
            switch result {
            case .success(let res):
                response(res.status == 200,res.result?.data)
                if res.status != 200 {
                    SpWindow.rootViewController?.Alert(message: res.msg ?? "" ,afterClose: 1.5)
                }
                break
            case .failure(let error):
                Print(error.localizedDescription)
                response(false,nil)
                break
            }
        }
    }
    
    func correctList<T:Codable>(param:[String:Any] ,response:@escaping((Bool,T?)->Void)) -> Void {
        self.request(.correctList(param)) { (result: Result<SpeakNetBaseMode<T>, Error>) in
            switch result {
            case .success(let res):
                response(res.status == 200,res.result?.data)
                if res.status != 200 {
                    SpWindow.rootViewController?.Alert(message: res.msg ?? "" ,afterClose: 1.5)
                }
                break
            case .failure(let error):
                Print(error.localizedDescription)
                response(false,nil)
                break
            }
        }
    }
    
}

enum SpeakProgressAPI : BaseTargetType {
    case wordCount
    case historyRecord
    case correctList([String:Any])
}

extension SpeakProgressAPI {
    
    var baseURL: URL {
        return URL(string: "https://feedapihk.zhangxinhulian.com")!
    }
    
    var path: String {
        switch self {
        case .wordCount:
            return "/api/learn/wordCount"
        case .historyRecord:
            return "/api/learn/historyRecord"
        case .correctList:
            return "/api/learn/correctList"
        }
    }
    
    var method: Moya.Method {
        switch self {
        case .wordCount ,.historyRecord ,.correctList:
            return .get
        }
    }
    
    var task: Task {
        switch self {
        case .wordCount ,.historyRecord:
            return .requestParameters(parameters: [:], encoding: URLEncoding.default)
        case .correctList(let param):
            return .requestParameters(parameters: param, encoding: URLEncoding.default)
        }
    }
    
    var headers: [String: String]? {
        return ["Content-Type": "application/json",
                    "Authorization":SpeakElePublicManager.share.userInfo.token ?? ""]
    }
}



