//
//  SpeakPracticeNetViewModel.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/7/25.
//

import UIKit
import Moya


class SpeakPracticeNetViewModel: NetworkUtil<PracticeAPI> {

    func learnedLesson<T:Codable>(response:@escaping((Bool,T?)->Void)) -> Void {
        self.request(.learnedLesson) { (result: Result<SpeakNetBaseMode<T>, Error>) in
            switch result {
            case .success(let res):
                response(res.status == 200,res.result?.data)
                if res.status != 200 {
                    SpWindow.rootViewController?.Alert(message: res.msg ?? "" ,afterClose: 1.5)
                }
                break
            case .failure(let error):
                Print(error.localizedDescription)
                response(false,nil)
                break
            }
        }
    }
    
    func leassionWord<T:Codable>(param : [String:Any] ,response:@escaping((Bool,T?)->Void)) -> Void {
        self.request(.lessonWords(param)) { (result: Result<SpeakNetBaseMode<T>, Error>) in
            switch result {
            case .success(let res):
                response(res.status == 200,res.result?.data)
                if res.status != 200 {
                    SpWindow.rootViewController?.Alert(message: res.msg ?? "" ,afterClose: 1.5)
                }
                break
            case .failure(let error):
                Print(error.localizedDescription)
                response(false,nil)
                break
            }
        }
    }
    
    func cardTranslate<T:Codable>(param:[String:Any], response:@escaping((Bool,T?)->Void)) -> Void {
        self.request(.cardTranslate(param)) { (result: Result<SpeakNetBaseMode<T>, Error>) in
            switch result {
            case .success(let res):
                response(res.status == 200,res.result?.data)
                if res.status != 200 {
                    SpWindow.rootViewController?.Alert(message: res.msg ?? "" ,afterClose: 1.5)
                }
                break
            case .failure(let error):
                Print(error.localizedDescription)
                response(false,nil)
                break
            }
        }
    }
    
    func wordMarkStatus<T:Codable>(param:[String:Any], response:@escaping((Bool,T?)->Void)) -> Void {
        self.request(.wordMarkStatus(param)) { (result: Result<SpeakNetBaseMode<T>, Error>) in
            switch result {
            case .success(let res):
                response(res.status == 200,res.result?.data)
                if res.status != 200 {
                    SpWindow.rootViewController?.Alert(message: res.msg ?? "" ,afterClose: 1.5)
                }
                break
            case .failure(let error):
                Print(error.localizedDescription)
                response(false,nil)
                break
            }
        }
    }
    
    func turnCard<T:Codable>(param:[String:Any], response:@escaping((Bool,T?)->Void)) -> Void {
        self.request(.turnCard(param)) { (result: Result<SpeakNetBaseMode<T>, Error>) in
            switch result {
            case .success(let res):
                response(res.status == 200,res.result?.data)
                if res.status != 200 {
                    SpWindow.rootViewController?.Alert(message: res.msg ?? "" ,afterClose: 1.5)
                }
                break
            case .failure(let error):
                Print(error.localizedDescription)
                response(false,nil)
                break
            }
        }
    }
}

enum PracticeAPI : BaseTargetType {
    case learnedLesson
    case lessonWords([String:Any])
    case cardTranslate([String:Any])
    case wordMarkStatus([String:Any])
    case turnCard([String:Any])
}


extension PracticeAPI {
    
    var baseURL: URL {
        return URL(string: "https://feedapihk.zhangxinhulian.com")!
    }
    
    var path: String {
        switch self {
        case .learnedLesson:
            return "/api/learn/learnedLesson"
        case .lessonWords:
            return "/api/learn/lessonWords"
        case .cardTranslate:
            return "/api/learn/cardTranslate"
        case .wordMarkStatus:
            return "/api/learn/wordMarkStatus"
        case .turnCard:
            return "/api/learn/turnCard"
        }
    }
    
    var method: Moya.Method {
        switch self {
        case .learnedLesson,.lessonWords,.cardTranslate,.wordMarkStatus:
            return .get
        case .turnCard:
            return .post
        }
    }
    
    var task: Task {
        switch self {
        case .learnedLesson:
            return .requestParameters(parameters: [:], encoding: URLEncoding.default)
        case .lessonWords(let param),.cardTranslate(let param),.wordMarkStatus(let param):
            return .requestParameters(parameters: param, encoding: URLEncoding.default)
        case .turnCard(let param):
            do {
                let pramdata = try JSONSerialization.data(withJSONObject: param)
                return .requestCompositeData(bodyData: pramdata, urlParameters: param)
            }catch{
                return .requestParameters(parameters: param, encoding: URLEncoding.httpBody)
            }
        }
    }
    
    var headers: [String: String]? {
        switch self {
        case .learnedLesson,.lessonWords:
            return ["Content-Type": "application/json",
                    "Authorization":SpeakElePublicManager.share.userInfo.token ?? ""]
        default:
            return ["Content-Type": "application/json",
                    "Authorization":SpeakElePublicManager.share.userInfo.token ?? ""]
        }
    }
}
