//
//  SpeakNetStatusManager.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/9/9.
//

import Alamofire
import Network

enum NetStatus{
    case NoNet
    case WIFI
    case WWAN
}

class SpeakNetStatusManager: NSObject {
    
    static let manager:SpeakNetStatusManager = SpeakNetStatusManager()
    private let monitor = NWPathMonitor()
    
    private let queue = DispatchQueue(label: "SpeakNetworkMonitorQueue")
    var currentStatus:NetStatus?
    
    func monitor(_ netStatus: @escaping(NetStatus)->Void) {
        monitor.pathUpdateHandler = { path in
            if path.status == .satisfied {
                if path.isExpensive {
                    self.currentStatus = .WWAN
                    netStatus(.WWAN)
                } else {
                    self.currentStatus = .WIFI
                    netStatus(.WIFI)
                }
            } else {
                self.currentStatus = .NoNet
                netStatus(.NoNet)
            }
        }
        monitor.start(queue: queue)
    }
    
    func stop() {
        monitor.cancel()
    }
}
