//
//  SpeakNetHomeViewModel.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/8/5.
//

import UIKit
import Moya


class SpeakNetHomeViewModel: NetworkUtil<SpeakHomeAPI> {

    func SpeakAllLessons<T:Codable>(complate:@escaping((Bool,T?)->Void)) -> Void {
        self.request(.lessons) { (result: Result<SpeakNetBaseMode<T>, Error>) in
            switch result {
            case .success(let res):
                complate(res.status == 200,res.result?.data)
                if res.status != 200 {
                    SpWindow.rootViewController?.Alert(message: res.msg ?? "" ,afterClose: 1.5)
                }
                break
            case .failure(let error):
                Print(error.localizedDescription)
                complate(false,nil)
                break
            }
        }
    }
    
    func SpeakGetLessonById<T:Codable>( param:[String:Any] ,complate:@escaping((Bool,T?)->Void)) -> Void {
        self.request(.getLessonById(param)) { (result: Result<SpeakNetBaseMode<T>, Error>) in
            switch result {
            case .success(let res):
                complate(res.status == 200,res.result?.data)
                if res.status != 200 {
                    SpWindow.rootViewController?.Alert(message: res.msg ?? "" ,afterClose: 1.5)
                }
                break
            case .failure(let error):
                Print(error.localizedDescription)
                complate(false,nil)
                break
            }
        }
    }
    
    func SpeakAILeasson<T:Codable>( param:[String:Any] ,complate:@escaping((Bool,T?)->Void)) -> Void {
        self.request(.aiLearn(param)) { (result: Result<SpeakNetBaseMode<T>, Error>) in
            switch result {
            case .success(let res):
                complate(res.status == 200,res.result?.data)
                if res.status != 200 {
                    SpWindow.rootViewController?.Alert(message: res.msg ?? "" ,afterClose: 1.5)
                }
                break
            case .failure(let error):
                Print(error.localizedDescription)
                complate(false,nil)
                break
            }
        }
    }
    
    func learnCourseHistoryRecordList<T:Codable>( param:[String:Any] ,complate:@escaping((Bool,T?)->Void)) -> Void {
        self.request(.learnCourseHistoryRecordList(param)) { (result: Result<SpeakNetBaseMode<T>, Error>) in
            switch result {
            case .success(let res):
                complate(res.status == 200,res.result?.data)
                if res.status != 200 {
                    SpWindow.rootViewController?.Alert(message: res.msg ?? "" ,afterClose: 1.5)
                }
                break
            case .failure(let error):
                Print(error.localizedDescription)
                complate(false,nil)
                break
            }
        }
    }
    
    func translate<T:Codable>( param:[String:Any] ,complate:@escaping((Bool,T?)->Void)) -> Void {
        self.request(.translate(param)) { (result: Result<SpeakNetBaseMode<T>, Error>) in
            switch result {
            case .success(let res):
                complate(res.status == 200,res.result?.data)
                if res.status != 200 {
                    SpWindow.rootViewController?.Alert(message: res.msg ?? "" ,afterClose: 1.5)
                }
                break
            case .failure(let error):
                Print(error.localizedDescription)
                complate(false,nil)
                break
            }
        }
    }
    
    func correct<T:Codable>( param:[String:Any] ,complate:@escaping((Bool,T?)->Void)) -> Void {
        self.request(.correct(param)) { (result: Result<SpeakNetBaseMode<T>, Error>) in
            switch result {
            case .success(let res):
                complate(res.status == 200,res.result?.data)
                if res.status != 200 {
                    SpWindow.rootViewController?.Alert(message: res.msg ?? "" ,afterClose: 1.5)
                }
                break
            case .failure(let error):
                Print(error.localizedDescription)
                complate(false,nil)
                break
            }
        }
    }
    
    func signList<T:Codable>( param:[String:Any] ,complate:@escaping((Bool,T?)->Void)) -> Void {
        self.request(.signList) { (result: Result<SpeakNetBaseMode<T>, Error>) in
            switch result {
            case .success(let res):
                complate(res.status == 200,res.result?.data)
                if res.status != 200 {
                    SpWindow.rootViewController?.Alert(message: res.msg ?? "" ,afterClose: 1.5)
                }
                break
            case .failure(let error):
                Print(error.localizedDescription)
                complate(false,nil)
                break
            }
        }
    }
    
    func getUserInfo<T:Codable>( param:[String:Any] ,complate:@escaping((Bool,T?)->Void)) -> Void {
        self.request(.getUserInfo) { (result: Result<SpeakNetBaseMode<T>, Error>) in
            switch result {
            case .success(let res):
                complate(res.status == 200,res.result?.data)
                if res.status != 200 {
                    SpWindow.rootViewController?.Alert(message: res.msg ?? "" ,afterClose: 1.5)
                }
                break
            case .failure(let error):
                Print(error.localizedDescription)
                complate(false,nil)
                break
            }
        }
    }
    
    func signUp<T:Codable>( param:[String:Any] ,complate:@escaping((Bool,T?)->Void)) -> Void {
        self.request(.signUp(param)) { (result: Result<SpeakNetBaseMode<T>, Error>) in
            switch result {
            case .success(let res):
                complate(res.status == 200,res.result?.data)
                if res.status != 200 {
                    SpWindow.rootViewController?.Alert(message: res.msg ?? "" ,afterClose: 1.5)
                }
                break
            case .failure(let error):
                Print(error.localizedDescription)
                complate(false,nil)
                break
            }
        }
    }
}



enum SpeakHomeAPI : BaseTargetType {
    case lessons
    case getLessonById([String:Any])
    case aiLearn([String:Any])
    case learnCourseHistoryRecordList([String:Any])
    case translate([String:Any])
    case correct([String:Any])
    case signList
    case getUserInfo
    case signUp([String:Any])
}

extension SpeakHomeAPI {
    
    var baseURL: URL {
        return URL(string: "https://feedapihk.zhangxinhulian.com")!
    }
    
    var path: String {
        switch self {
        case .lessons:
            return "/api/learn/lessons"
        case .getLessonById:
            return "/api/learn/getLessonById"
        case .aiLearn:
            return "/api/learn/aiLearn"
        case .learnCourseHistoryRecordList:
            return "/api/learn/learnCourseHistoryRecordList"
        case .translate:
            return "/api/learn/translate"
        case .correct:
            return "/api/learn/correct"
        case .signList:
            return "/api/learn/signList"
        case .getUserInfo:
            return "/api/learn/getUserInfo"
        case .signUp:
            return "/api/learn/signUp"
        }
    }
    
    var method: Moya.Method {
        switch self {
        case .lessons ,.getLessonById ,.learnCourseHistoryRecordList ,.translate ,.correct ,.signList ,.getUserInfo,.signUp:
            return .get
        case .aiLearn:
            return .post
        }
    }
    
    var task: Task {
        switch self {
        case .lessons ,.signList ,.getUserInfo:
            return .requestParameters(parameters: [:], encoding: URLEncoding.default)
        case .getLessonById(let param) ,.learnCourseHistoryRecordList(let param) ,.translate(let param) ,.correct(let param) ,.signUp(let param):
            return .requestParameters(parameters: param, encoding: URLEncoding.default)
        case .aiLearn(let param):
            do {
                let pramdata = try JSONSerialization.data(withJSONObject: param)
                return .requestCompositeData(bodyData: pramdata, urlParameters: param)
            }catch{
                return .requestParameters(parameters: param, encoding: URLEncoding.httpBody)
            }
        }
    }
    
    var headers: [String: String]? {
        switch self {
        case .lessons:
            return ["Content-Type": "application/json",
                    "Authorization":SpeakElePublicManager.share.userInfo.token ?? ""]
        default:
            return ["Content-Type": "application/json",
                    "Authorization":SpeakElePublicManager.share.userInfo.token ?? ""]
        }
    }
}
