//
//  SpeakEleProfileNetViewModel.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/7/29.
//

import UIKit
import Moya


class SpeakEleProfileNetViewModel: NetworkUtil<SpeakProfileApi> {
    ///  收藏的课程
    func collectLessonList<T:Codable>(param:[String:Any], response:@escaping((Bool,T?)->Void)) -> Void {
        self.request(.collectLessonList(param)) { (result: Result<SpeakNetBaseMode<T>, Error>) in
            switch result {
            case .success(let res):
                response(res.status == 200,res.result?.data)
                if res.status != 200 {
                    SpWindow.rootViewController?.Alert(message: res.msg ?? "" ,afterClose: 1.5)
                }
                break
            case .failure(let error):
                Print(error.localizedDescription)
                response(false,nil)
                break
            }
        }
    }

    /// 收藏的单词
    func collectWordList<T:Codable>(param:[String:Any], response:@escaping((Bool,T?)->Void)) -> Void {
        self.request(.collectWordList(param)) { (result: Result<SpeakNetBaseMode<T>, Error>) in
            switch result {
            case .success(let res):
                response(res.status == 200,res.result?.data)
                if res.status != 200 {
                    SpWindow.rootViewController?.Alert(message: res.msg ?? "" ,afterClose: 1.5)
                }
                break
            case .failure(let error):
                Print(error.localizedDescription)
                response(false,nil)
                break
            }
        }
    }

    /// 收藏
    /// businessId 单词id或者课程id
    /// type 类型1为课程 2为单词
    /// isCollect 是收藏还是取消收藏
    func collect(param:[String:Any], response:@escaping((Bool,SpeakNetBaseDeflutMode?)->Void)) -> Void {
        self.request(.collect(param)) { (result: Result<SpeakNetBaseMode<SpeakNetBaseDeflutMode>, Error>) in
            switch result {
            case .success(let res):
                response(res.status == 200,res.result?.data)
                if res.status != 200 {
                    SpWindow.rootViewController?.Alert(message: res.msg ?? "" ,afterClose: 1.5)
                }
                break
            case .failure(let error):
                Print(error.localizedDescription)
                response(false,nil)
                break
            }
        }
    }
    
    
    func deleteAccout(param:[String:Any], response:@escaping((Bool,SpeakNetBaseDeflutMode?)->Void)) -> Void {
        self.request(.deleteAccount(param)) { (result: Result<SpeakNetBaseMode<SpeakNetBaseDeflutMode>, Error>) in
            switch result {
            case .success(let res):
                response(res.status == 200,res.result?.data)
                if res.status != 200 {
                    SpWindow.rootViewController?.Alert(message: res.msg ?? "" ,afterClose: 1.5)
                }
                break
            case .failure(let error):
                Print(error.localizedDescription)
                response(false,nil)
                break
            }
        }
    }
}

enum SpeakProfileApi:BaseTargetType {
    case collectLessonList([String:Any])
    case collectWordList([String:Any])
    case collect([String:Any])
    case deleteAccount([String:Any])
}

extension SpeakProfileApi {
    var baseURL: URL {
        return URL(string: "https://feedapihk.zhangxinhulian.com")!
    }
    
    var path: String {
        switch self {
        case .collectLessonList:
            return "/api/learn/collectLessonList"
        case .collectWordList:
            return "/api/learn/collectWordList"
        case .collect:
            return "/api/learn/collect"
        case .deleteAccount:
            return "/api/learn/deleteAccount"
        }
    }
    
    var method: Moya.Method {
        switch self {
        case .collectLessonList ,.collectWordList ,.collect ,.deleteAccount:
            return .get
        }
    }
    
    var task: Task {
        switch self {
        case .collectLessonList(let param),.collectWordList(let param) ,.collect(let param) ,.deleteAccount(let param):
            return .requestParameters(parameters: param, encoding: URLEncoding.default)
        }
    }
    
    var headers: [String: String]? {
        switch self {
        case .collectLessonList:
            return ["Content-Type": "application/json",
                    "Authorization":SpeakElePublicManager.share.userInfo.token ?? ""]
        default:
            return ["Content-Type": "application/json",
                    "Authorization":SpeakElePublicManager.share.userInfo.token ?? ""]
        }
    }
    
}
