//
//  SpeakEleNetViewModel.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/7/21.
//

import UIKit
import Moya

protocol BaseTargetType: TargetType {
}


class NetworkUtil<Service: BaseTargetType> {
    
    let alert = SpeakAlertHUD.share
    
    private let provider: MoyaProvider<Service>
    init(provider: MoyaProvider<Service> = MoyaProvider<Service>()) {
        self.provider = provider
    }
    
    // 发送网络请求
    func request<T: Decodable>(_ target: Service ,completion: @escaping (Result<SpeakNetBaseMode<T>, Error>) -> Void) {
        provider.request(target) { result in
            switch result {
            case .success(let response):
                do {
                    #if DEBUG
                    let string = try response.mapString()
                    Print(target.baseURL.absoluteString + target.path + string)
                    #endif
                    let decoded = try response.map(SpeakNetBaseMode<T>.self)
                    completion(.success(decoded))
                } catch {
                    completion(.failure(error))
                }
            case .failure(let error):
                completion(.failure(error))
            }
        }
    }
}

struct SpeakNetBaseMode<T:Codable> : Codable {
    var status:Int?
    var msg:String?
    var result:SpeakNetBaseDataMode<T>?
    var extras:String?
}

struct SpeakNetBaseDataMode<T:Codable> : Codable {
    var data:T?
}

struct SpeakNetBaseDeflutMode : Codable {
}
