//
//  AdRevenueTracker.swift
//  PhoneManager
//
//  Created by edy on 2025/6/18.
//

import Foundation
import Foundation
import FirebaseAnalytics
import StoreKit
import AdjustSdk

class AdRevenueTracker {

    // 订阅上报数据
    func purchasingSuccessReport(type:Int){
        guard let prod = IAPViewModel.share.IAPProducts?[type] else{
            return
        }
        // firebase上报
        let pram = [
            AnalyticsParameterValue:prod.price.floatValue,
            AnalyticsParameterCurrency:prod.priceLocale.currencyCode ?? "USD"
        ] as [String : Any]
        Analytics.logEvent("hybrid_revenue", parameters: pram)
        // adjust上报
        guard let event = ADJEvent(eventToken: "ywk8y5") else { return }
        event.setRevenue(prod.price.doubleValue, currency: prod.priceLocale.currencyCode ?? "USD")
        Adjust.trackEvent(event)
    }
}

