//
//  SpeakElePublicManager.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/7/11.
//

import UIKit

class SpeakElePublicManager: NSObject {

    static let share = SpeakElePublicManager()
    
    var PublicData:PublicModel = PublicModel()
    
    var userInfo:UserMode = UserMode()
    
    func loadData() -> Void {
        do {
            let manager = UserDefaults.standard.object(forKey: UnsafeRawUserDefaultsKey.UnsafePublicDataKey.rawValue) as? Data ?? Data()
            let data = try JSONDecoder().decode(PublicModel.self, from: manager)
            PublicData = data
            
            let User = UserDefaults.standard.object(forKey: UnsafeRawUserDefaultsKey.UnsafeUserInfoDataKey.rawValue) as? Data ?? Data()
            let userData = try JSONDecoder().decode(UserMode.self, from: User)
            userInfo = userData
        }catch{
            
        }
    }
    
    func saveData() -> Void {
        do{
            let encoder = JSONEncoder()
            encoder.outputFormatting = .prettyPrinted
            let data = try encoder.encode(PublicData)
            UserDefaults.standard.set(data, forKey: UnsafeRawUserDefaultsKey.UnsafePublicDataKey.rawValue)
            
            let userData = try encoder.encode(userInfo)
            UserDefaults.standard.set(userData, forKey: UnsafeRawUserDefaultsKey.UnsafeUserInfoDataKey.rawValue)
            
            UserDefaults.standard.synchronize()
        }catch {
        }
    }
    
    private override init() { }
}


enum guideState:Int,Codable{
    /// 开始
    case start = 0
    /// 订阅
    case subscribe = 1
    /// 问答
    case qanda = 2
    /// 登录
    case login = 3
    ///  首页
    case home = 4
}

struct PublicModel : Codable {
    
    var state:guideState = .start
    
    /// 其它语言
    var LikeLanguage:String = ""
    /// 爱好
    var MHobby:String = ""
    /// 改善
    var MImproving:String = ""
    /// 水平
    var MProficiency:Int = 1
    /// 目标时间
    var MGoalDays:String = ""
    /// 学习时间
    var MStudytime:String = ""
    /// 练习时间
    var MPractice:String = ""
    /// 是否推送
    var isReminder:Bool = true
    /// 智能提示
    var Smarttips:Bool = true
    /// 倍速
    var speed:CGFloat = 1.0
    /// 提示是否已显示
    var isShowDialogTip = false
    /// ai 语音默认的是第几个
    var AIerIndex = 0
}



