//
//  SpeakDayEveryManager.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/7/28.
//

import UIKit

class SpeakDayEveryManager: NSObject {

    static let manager = SpeakDayEveryManager()
    private let db = SpeakDayDatabase()
    
    func loadData(_ date:String) -> Void {
        SpeakDayData = db.getByDate(date: date) ?? SpeakDayModel(date: Date().toStr() ,id: 10000 , PracticeFreeNum: 2 ,studyFreeTm: 300)
    }
    
    func fetchStudyTime(date:[String],complate:(([SpeakDayModel])->Void)? ) -> [SpeakDayModel] {
        let date = db.GetByDates(dates: date)
        return date ?? []
    }
    
    func update() -> Void {
        if SpeakDayData.id == 10000 {
            db.insert(model: SpeakDayData)
            self.loadData(SpeakDayData.date ?? "")
        }else{
            db.update(model: SpeakDayData)
        }
    }
    
    var SpeakDayData:SpeakDayModel = SpeakDayModel()
    
    func deleteTab() -> Void {
        _ = db.deleteTab()
    }
    
    private override init() {
    }
}

struct SpeakDayModel {
    var date:String?            // 时间
    var id:Int?
    var PracticeFreeNum:Int?    // 卡片免费翻译次数
    var studyFreeTm:Int?        // 每天免费时间 秒
    var studytime:Int?          // 每天学习的时间
}
