//
//  Value+Extension.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/7/3.
//

import UIKit

protocol NumericType: Numeric, Comparable, ExpressibleByFloatLiteral {
    init(_ value: Double)
    var doubleValue:Double { get }
}

extension Float: NumericType {
    var doubleValue: Double { Double(self) }
}

extension Double: NumericType {
    var doubleValue: Double { Double(self) }
}

extension CGFloat: NumericType {
    var doubleValue: Double { Double(self) }
}

extension NumericType {
    func adapterW() -> Double {
        return self.doubleValue * (Dev.screenW / 402.0)
    }
    
    func adapterH() -> Double {
        return self.doubleValue * (Dev.screenW / 812.0)
    }
}
