//
//  UIWindow+Extension.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/7/10.
//

import UIKit


extension UIWindow {
    
    private func setRootViewControllerWithTransition(_ viewController: UIViewController, transition: CATransition) {
        self.layer.add(transition, forKey: kCATransition)
        self.rootViewController = viewController
        self.makeKeyAndVisible()
    }
    
    func switchToController(_ vc:UIViewController) {
        let transition = CATransition()
        transition.duration = 0.35
        transition.type = .push
        transition.subtype = .fromRight
        transition.timingFunction = CAMediaTimingFunction(name: .easeInEaseOut)
        setRootViewControllerWithTransition(vc, transition: transition)
    }
}
