//
//  UIViewController+Extension.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/7/21.
//

import UIKit

extension UIViewController {
    public func Alert(_ titile:String? = nil ,
                  message:String = "" ,
                  action:[String] = [] ,
                  afterClose:Double = 1.5,
                  autoClose:Bool = true,
                  complate:@escaping((UIAlertController ,Int)->Void) = { v , idx in} ) {
        if message.isEmpty {
            return
        }
        
        let alertview = UIAlertController(title: titile, message: message, preferredStyle: .alert)
        self.present(alertview, animated: true)
        let afterT = DispatchTime.now() + afterClose
        if action.count > 0 {
            for (i,title) in action.enumerated() {
                let action = UIAlertAction(title: title, style: .default) { action in
                    complate(alertview,i)
                }
                alertview.addAction(action)
            }
            if autoClose {
                DispatchQueue.main.asyncAfter(deadline: afterT) {
                    complate(alertview ,-1)
                    alertview.dismiss(animated: true)
                }
            }
        }else{
            DispatchQueue.main.asyncAfter(deadline: afterT) {
                complate(alertview ,-1)
                alertview.dismiss(animated: true)
            }
        }
    }
}
