//
//  SKProduct+Extension.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/7/18.
//

import UIKit
import StoreKit

extension SKProduct {
    var localizedPrice: String {
        if priceLocale != nil {
            let formatter = NumberFormatter()
            formatter.numberStyle = .currency
            formatter.locale = priceLocale
            formatter.maximumFractionDigits = 2
            guard let priceNumber:NSNumber = price as? NSNumber else {
                return ""
            }
            return formatter.string(from: priceNumber) ?? ""
        }
        return "--"
    }
    
    var symbol:String {
        guard let local = priceLocale as? Locale else { return "" }
        let priceLocale = try self.priceLocale
        return priceLocale.currencySymbol ?? ""
    }
}
