//
//  Date+Extension.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/7/17.
//

import UIKit

extension Date {
    
    public func toStr(_ formatter:String = "yyyyMMdd") -> String? {
        let format = DateFormatter()
        format.dateFormat = formatter
        return format.string(from: self)
    }
    
    func toWeek() -> String {
        let format = DateFormatter()
        format.dateFormat = "EEE"
        if self.toStr() == Date().toStr() {
            return "Today"
        }
        return format.string(from: self)
    }
    
    func Common(year:Int = 0,
                   month:Int = 0,
                   day:Int = 0,
                   houre:Int = 0,
                   minte:Int = 0,
                   second:Int = 0,
                   week:Int = 0) -> Date {
        let calendar = Calendar.current
        let currentDate = self
        var dateComponent:DateComponents = calendar.dateComponents([.year,.month,.day,.hour,.minute,.second,.weekday], from: currentDate)
        dateComponent.year! += year
        dateComponent.month! += month
        dateComponent.day! += day
        dateComponent.hour! += houre
        dateComponent.minute! += minte
        dateComponent.second! += second
        dateComponent.weekday! += week
        guard let toDate = calendar.date(from: dateComponent) else { return self }
        return toDate
    }
}
