//
//  SpeakEleConfigs.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/7/3.
//

import UIKit

#if DEBUG
let isDebug = true
#else
let isDebug = false
#endif

let marginLR:Double = 24

let SpeakIAPWeekIdentifier = "com.speakeasy.ai.ap.week"
let SpeakIAPYearIdentifier = "com.speakeasy.ai.ap.year"

let SpeakTerms =    "https://v0-speak-easy-ai-documentation.vercel.app/terms"
let SpeakPrivacy =  "https://v0-speak-easy-ai-documentation.vercel.app/privacy"
/// 评分
let SpeakRateURL = "itms-apps://itunes.apple.com/app/id6748631330?action=write-review"
/// 分享app
let AppStoreShare = "https://apps.apple.com/app/id6748631330"

let googleClent = "229038964598-v6egjvmfllfucmkn6bt4pupdg93l2eqg.apps.googleusercontent.com"

let appID = "6748631330"

// MARK: - 所有分类属性 Key
enum SpeakEasyAssociatedKeys : UInt32 {
    case fontsize = 0x101010
    case UnsafeCallBack = 0x10000
    case labelTextTap = 0x10001
    case contentLabelState = 0x10002
    case navigationAniKey = 0x01122
    case labelTextCutomFont = 0x01102
    case windowkeyboardKey = 0x120323
}

protocol CutomFontProtocol : NSObjectProtocol {
    var fontSize:CGFloat { get set }
    var cutomFont:Int { get }
    
    func setCutomFonts() -> Void
    
}

// MARK: - userdefaultKey
enum UnsafeRawUserDefaultsKey:String {
    case UnsafeThreeDayGuide = "UnsafeThreeDayGuide"
    case UnsafePublicDataKey = "UnsafePublicDataKey"
    case UnsafeUserInfoDataKey = "UnsafeUserInfoDataKey"
    case UnsafeGuideQAKey = "UnsafeGuideQAKey"
    case UnsafeLockPracWord = "UnsafeLockPracWord"
    case UnsafePracticeTipsShow = "UnsafePracticeTipsShowKey"
    case UnsafePracticeFailTipsShow = "UnsafePracticeFailTipsShowKey"
    case UnsafeDialogReviewShow = "UnsafeDialogReviewShowKey"
}


// MARK: - Notification Names
extension Notification.Name {
    static let subscriptionStatusChanged = Notification.Name("IAPSubscriptionStatusChanged")
    static let subscriptionVerify = Notification.Name("IAPSubscriptionStatusVerify")
    
    static let ProfilesettingUpdateUI = Notification.Name("ProfilesettingUpdateUI")
    static let UserInfoUpdate = Notification.Name("UserInfoUpdate")
    
}
