//
//  Common.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/7/3.
//

import UIKit

struct Dev {
    static let screenW = UIScreen.main.bounds.size.width
    static let screenH = UIScreen.main.bounds.size.height
    static let navHeight:CGFloat = 44
    static let tabHeight = 49
    static let safeAreaInsets:UIEdgeInsets = SpWindow.safeAreaInsets
}

let SpWindow:UIWindow = {
    if #available(iOS 13, *) {
        return UIApplication.shared.connectedScenes
            .compactMap { $0 as? UIWindowScene }
            .first?.windows.first ?? UIWindow()
    } else {
        return UIApplication.shared.keyWindow ?? UIWindow()
    }
}()

public func Print(_ items: Any...,
                  file: String = #file,
                  line: Int = #line,
                  function: String = #function) {
    #if DEBUG
    let fileURL = URL(fileURLWithPath: file).lastPathComponent
    let dateFormatter = DateFormatter()
    dateFormatter.dateFormat = "HH:mm:ss.SSS"
    let timestamp = dateFormatter.string(from: Date())
    let output = items.map { "\($0)" }.joined(separator: " ")
    print("[\(timestamp)] \(fileURL):\(line) \(function) \n\t\(output)\n")
    #else
    #endif
}

/// 状态栏高度
var statusBarHeight: CGFloat {
//        UIApplication.shared.statusBarFrame.height
    UIApplication.shared.windows.first?.windowScene?.statusBarManager?.statusBarFrame.height ?? 0.00
    
}
/// 导航栏高度
var naviBarHeight: CGFloat {
    UINavigationController().navigationBar.frame.size.height
}

/// Tabbar高度
var tabbarHeight: CGFloat {
    49.0 + tabbarSpace
}
/// Tabbar安全区域高度
var tabbarSpace: CGFloat {
    isIphoneNotch ? 34 : 0
}

/// 是否刘海屏
var isIphoneNotch: Bool {
    statusBarHeight > 20
}


func copyMatchingProperties<T, U>(from source: T, to destination: inout U) {
    let sourceMirror = Mirror(reflecting: source)
    let destinationMirror = Mirror(reflecting: destination)
    for sourceChild in sourceMirror.children {
        Print("\(String(describing: sourceChild.label)) \(sourceChild.value)")
        guard let sourceLabel = sourceChild.label,
              let b = sourceChild.value as? AnyObject ,
              !(b is NSNull)  else { continue }
        for destinationChild in destinationMirror.children {
            guard let destinationLabel = destinationChild.label,
                  sourceLabel == destinationLabel else { continue }
            if type(of: sourceChild.value) == type(of: destinationChild.value) {
                if let mutableDestination = destination as? AnyObject,
                   let sourceValue = sourceChild.value as? AnyObject,
                    sourceValue != nil {
                    mutableDestination.setValue(sourceValue, forKey: sourceLabel)
                }
            }
        }
    }
}


func updateUserInformation(_ complate:((Bool)->Void)? = nil) -> Void {
    if SpeakElePublicManager.share.userInfo.isLogin() {
        let name = SpeakElePublicManager.share.userInfo.userName ?? ""
        let lanaguage = SpeakElePublicManager.share.userInfo.nativeLanguage ?? ""
        let email = SpeakElePublicManager.share.userInfo.email ?? ""
        let level = SpeakElePublicManager.share.PublicData.MProficiency
        let en = SpeakElePublicManager.share.userInfo.targetLanguage == "🇬🇧 English" ? "en" : "es"
        let viewmodel = SpeakUserNetViewModel()
        viewmodel.update(param: [
            "userName" : name,
            "nativeLanguage": lanaguage,
            "email": email,
            "targetLevel": level,
            "targetLanguage":en
        ]) { su in
            complate?(su)
        }
    }
}


func getTopMostViewCtr() -> UIViewController? {
    guard let window = UIApplication.shared.windows.first(where: { $0.isKeyWindow }) else {
        return nil
    }
    var topViewController = window.rootViewController
    while let navigationController = topViewController as? UINavigationController {
        topViewController = navigationController.topViewController
    }
    while let tabBarController = topViewController as? UITabBarController {
        topViewController = tabBarController.selectedViewController
    }
    while let presentedViewController = topViewController?.presentedViewController {
        topViewController = presentedViewController
        if let navigationController = topViewController as? UINavigationController {
            topViewController = navigationController.topViewController
        }
    }
    return topViewController
}


func toIAP(_ parent:UIViewController) -> Void {
    SpeakElePublicManager.share.PublicData.state = .subscribe
    let iap = SpeakEleIAPViewCtr()
    iap.state = .guide
    iap.navigationController?.AnimationState = .present
    parent.navigationController?.pushViewController(iap, animated: true)
}
