//
//  SpeakEleBaseViewCtr.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/7/3.
//

import UIKit

class SpeakEleBaseViewCtr: UIViewController {

    let alert = SpeakAlertHUD.share
    
    override func viewDidLoad() {
        super.viewDidLoad()
        view.backgroundColor = .white
    }
    
    var rightImage:String = "" {
        didSet{
            titleView.right.setImage(UIImage(named: rightImage), for: .normal)
            titleView.right.isHidden = rightImage.isEmpty
        }
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        setup()
        titleView.snp.makeConstraints { make in
            make.left.right.top.equalToSuperview()
            make.height.equalTo(Dev.navHeight + Dev.safeAreaInsets.top)
        }
        titleView.isHidden = !(self.navigationController?.viewControllers.count ?? 0 > 1)
    }
    
    func setup() -> Void {
        
    }
    
    @objc func PopViewCtr() -> Void {
        self.navigationController?.popViewController(animated: true)
    }
    
    @objc func rightTaps() -> Void {
        
    }

    func loadData() -> Void{
        
    }
    
    deinit {
        display.invalidate()
        Print("\(type(of: self)) deinit")
    }
    
    override var title: String? {
        didSet {
            titleView.titleLabel.text = title
        }
    }
    
    lazy var titleView: SpeakTitleView = {
        let titleV = SpeakTitleView()
        view.addSubview(titleV)
        titleV.backgroundColor = .white
        titleV.backBtn.addTarget(self, action: #selector(PopViewCtr), for: .touchUpInside)
        titleV.right.addTarget(self, action: #selector(rightTaps), for: .touchUpInside)
        return titleV
    }()
    
    lazy var display: CADisplayLink = {
        let display = CADisplayLink(target: self, selector: #selector(SpeakUpdate))
        display.add(to: RunLoop.main, forMode: .common)
        display.preferredFramesPerSecond = 1
        display.isPaused = true
        return display
    }()
    
    @objc public func SpeakUpdate() -> Void {
        
    }
}

class SpeakTitleView: UIView {
 
    override init(frame: CGRect) {
        super.init(frame: frame)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    private func setupUI() -> Void {
        titleLabel.snp.makeConstraints { make in
            make.centerX.equalToSuperview()
            make.bottom.equalToSuperview()
            make.top.equalToSuperview().offset(Dev.safeAreaInsets.top)
        }
        backBtn.snp.makeConstraints { make in
            make.left.equalToSuperview().inset(marginLR-4)
            make.centerY.equalTo(titleLabel)
        }
        right.snp.makeConstraints { make in
            make.right.equalToSuperview().inset(marginLR-4)
            make.centerY.equalTo(titleLabel)
        }
    }
    
    lazy var titleLabel: UILabel = {
        let label = UILabel()
        addSubview(label)
        label.font = UIFont.montserrat(.semiBold,size: 20)
        return label
    }()
    
    lazy var backBtn: UIButton = {
        let back = UIButton(type: .custom)
        back.setImage(UIImage(named: "sp-Back"), for: .normal)
        addSubview(back)
        return back
    }()
    
    fileprivate lazy var right: UIButton = {
        let right = UIButton(type: .custom)
        addSubview(right)
        right.isHidden = true
        return right
    }()
    
}
