# 分类选择器组件使用说明

## AppCategorySelector

单选分类选择器，支持双向绑定。

### 使用方法

1. 导入组件：

```javascript
import AppCategorySelector from '@/components/Selectors/AppCategorySelector'

export default {
  components: {
    AppCategorySelector
  }
}
```

2. 在模板中使用：

```html
<template>
  <div>
    <!-- 基本用法 -->
    <app-category-selector v-model="categoryId" @change="handleCategoryChange" />
    
    <!-- 当前选中的分类ID: {{ categoryId }} -->
  </div>
</template>

<script>
export default {
  data() {
    return {
      categoryId: '' // 存储选中的分类ID
    }
  },
  methods: {
    handleCategoryChange(value) {
      console.log('分类已更改:', value)
      // 执行其他操作...
    }
  }
}
</script>
```

### 属性

| 属性名 | 类型 | 默认值 | 说明 |
|--------|------|--------|------|
| value  | String/Number | '' | 当前选中的分类ID，支持v-model双向绑定 |

### 事件

| 事件名 | 参数 | 说明 |
|--------|------|------|
| input  | value | 选中值变化时触发，用于v-model |
| change | value | 选中值变化时触发 |
