import Vue from "vue";
import VCharts from "v-charts";
import "normalize.css/normalize.css"; // A modern alternative to CSS resets

import ElementUI from "element-ui";
import "element-ui/lib/theme-chalk/index.css";
import locale from "element-ui/lib/locale/lang/zh-CN"; // lang i18n

import "@/styles/index.scss"; // global css

import App from "./App";
import store from "./store";
import router from "./router";

import "@/icons"; // icon
import "@/permission"; // permission control

import "@/assets/css/flex.css";
import "@/assets/css/fontColor.css";
import "@/assets/css/fontSize.css";

import ViewUI from "view-design";
import "view-design/dist/styles/iview.css";
import { gatewayUserRouters } from "@/api/login";

import VueClipboard from "vue-clipboard2";
Vue.use(VueClipboard);

Vue.use(ElementUI, { locale });
Vue.use(VCharts);
Vue.use(ViewUI);

import ZxDatePicker from './components/zx-ui/index.js'
import ZxCommonTable from './components/zx-ui/index.js'
import ZxAppSelect from './components/zx-ui/index.js'
import ZxSourceSelect from './components/zx-ui/index.js'
import ZxGpaccountSelect from './components/zx-ui/index.js'

Vue.use(ZxDatePicker)
Vue.use(ZxCommonTable)
Vue.use(ZxAppSelect)
Vue.use(ZxSourceSelect)
Vue.use(ZxGpaccountSelect)

import Zxtable from "@/components/Table"
Vue.component(Zxtable.name, Zxtable);

// 全局注册掌心常用组件 注意：在封装公共组件时，请写清组件名，直接进行注册
import common from '@/components/zx-common-cpn'
console.log('通用组件', common);
Object.values(common).map(item => {
  Vue.component(item.name, item)
})

Vue.config.productionTip = false;

Vue.filter("toFixed", function (price, limit) {
  return price.toFixed(limit);
});

router.beforeEach((to, from, next) => {
  if (to.path == "/login" || to.path == "/materialUpload" || to.path == "/materialTag" || to.path == "/tools/uploadYoutubeNew" || to.path == "/privacy" || to.path == "/facebook-auth") {
    next();
  } else {
    gatewayUserRouters().then(res => {
      let showList = res.result.data;

      let nameNum = 0;
      for (let i = 0; i < showList.length; i++) {
        if (showList[i].key && showList[i].key === to.name) {
          nameNum = nameNum + 1;
        }
      }

      if (to.name && nameNum === 0) {
        next({ path: "/404" });
      }
      next();
    });
  }
});

new Vue({
  el: "#app",
  router,
  store,
  render: h => h(App)
});
