import request from "@/utils/request";

export function userList(params) {
  return request({
    url: process.env.ZX_NMS_BASE_API + "/user/userList",
    method: "get",
    params
  });
}

export function accept(data) {
  return request({
    url: process.env.ZX_NMS_BASE_API + "/user/accept",
    method: "post",
    data
  });
}

export function reject(data) {
  return request({
    url: process.env.ZX_NMS_BASE_API + "/user/reject",
    method: "post",
    data
  });
}

export function queryTotalWithdraw(params) {
  return request({
    url: process.env.ZX_NMS_BASE_API + "/withdraw/queryTotalApi",
    method: "get",
    params
  });
}

export function queryWithdrawList(params) {
  return request({
    url: process.env.ZX_NMS_BASE_API + "/withdraw/queryApi",
    method: "get",
    params
  });
}

export function acceptWd(data) {
  return request({
    url: process.env.ZX_NMS_BASE_API + "/withdraw/accept",
    method: "post",
    data
  });
}

export function goBackWd(data) {
  return request({
    url: process.env.ZX_NMS_BASE_API + "/withdraw/goBack",
    method: "post",
    data
  });
}

export function rejectWd(data) {
  return request({
    url: process.env.ZX_NMS_BASE_API + "/withdraw/reject",
    method: "post",
    data
  });
}

export function rollbackWd(data) {
  return request({
    url: process.env.ZX_NMS_BASE_API + "/withdraw/rollback",
    method: "post",
    data
  });
}

export function changeSourceInfo(data) {
  return request({
    url: process.env.ZX_NMS_BASE_API + "/user/changeSourceInfo",
    method: "post",
    data
  });
}

export function auditInfo(params) {
  return request({
    url: process.env.ZX_NMS_BASE_API + "/cloudDistribute/auditInfo",
    method: "get",
    params
  });
}
// 保存文章
export function pArticleSaveApi(data) {
  return request({
    url: process.env.CLOND_API + "/pArticle/save",
    method: "post",
    data
  });
}
// 文章列表
export function pArticleListApi(params) {
  return request({
    url: process.env.CLOND_API + "/pArticle/fetch",
    method: "get",
    params
  });
}
// 当前文章
export function currPArticleApi(params) {
  return request({
    url: process.env.CLOND_API + "/pArticle/getArticle",
    method: "GET",
    params
  });
}
// del文章
export function delPArticleApi(params) {
  return request({
    url: process.env.CLOND_API + "/pArticle/delArticle",
    method: "POST",
    params
  });
}

// 获取默认信息
export function getEnums(params) {
  return request({
    url: process.env.PUTIN_API + "/v1/global/enums",
    method: "GET",
    params
  });
}

/* 获取抓取任务列表 */
export function getTask(params) {
  return request({
    url: process.env.PUTIN_API + "/material/fetch/task",
    method: "GET",
    params
  });
}
/* 创建抓取任务列表 */
export function cresteTask(data) {
  return request({
    url: process.env.PUTIN_API + "/material/fetch/task",
    method: "POST",
    data: data
  });
}

/* 获取原始素材列表*/
export function getOlist(params) {
  return request({
    url: process.env.PUTIN_API + "/material/origin/list",
    method: "GET",
    params
  });
}
/* 获取原始素材库*/
export function getTextlist(params) {
  return request({
    url: process.env.PUTIN_API + "/material/origin/text/list",
    method: "GET",
    params
  });
}

/* 删除/入库的文案*/
export function getTextedit(params) {
  return request({
    url: process.env.PUTIN_API + "/material/origin/text/edit",
    method: "POST",
    params
  });
}

/* 创建素材组的下拉列表*/
export function getSelectApps(params) {
  return request({
    url: process.env.BXDD_API + "/cms/menu/selectApps",
    method: "GET",
    params
  });
}

/* 获取投放任务列表*/
export function putinFetchPutinTasks(params) {
  // return request({
  //   url: process.env.PUTIN_API + "/putin/fetch/putin/tasks",
  //   method: "GET",
  //   params
  // });
}

/* 获取创意素材库列表 */
export function getBusinlist(params) {
  return request({
    url: process.env.PUTIN_API + "/material/business/list",
    method: "GET",
    params
  });
}

// 获取回显素材列表
export function getShowParams(params) {
  return request({
    url: process.env.PUTIN_API + "/material/group/list",
    method: 'get',
    params
  })
}

/* 获取创意素材 */
export function getBusinIncome(params) {
  return request({
    url: process.env.BXDD_API + "/stat/common/v2/tableMapping",
    method: "GET",
    params
  });
}


/* 删除创意素材库列表 */
export function getBusindel(params) {
  return request({
    url: process.env.PUTIN_API + "/material/business/del",
    method: "POST",
    params
  });
}

/* 文件上传 */
export function getUpload(data) {
  return request({
    url: process.env.PUTIN_API + "/v1/global/upload",
    method: "POST",
    data
  });
}

/* 本地上传到素材库*/
export function getbusinUpload(params) {
  return request({
    url: process.env.PUTIN_API + "/material/business/upload",
    method: "POST",
    params
  });
}

/* 获取文案库列表*/
export function getBusinText(params) {
  return request({
    url: process.env.PUTIN_API + "/material/business/text/list",
    method: "GET",
    params
  });
}

/* 删除文案库*/
export function getBusinTextDel(params) {
  return request({
    url: process.env.PUTIN_API + "/material/business/text/del",
    method: "POST",
    params
  });
}

/* 修改文案库*/
export function getBusinTextEdit(data) {
  return request({
    url: process.env.PUTIN_API + "/material/business/text/edit",
    method: "POST",
    data
  });
}

/* 添加文案库*/
export function getBusinTextAdd(data) {
  return request({
    url: process.env.PUTIN_API + "/material/business/text/input-add",
    method: "POST",
    data
  });
}

/* 操作原始素材*/
export function getoriginedit(data) {
  return request({
    url: process.env.PUTIN_API + "/material/origin/edit",
    method: "POST",
    data
  });
}

/* 获取素材组的列表*/
export function getGrouplist(params) {
  return request({
    url: process.env.PUTIN_API + "/material/v2/group/list",
    method: "GET",
    params
  });
}

/* 清洗素材 */
export function getCleanService(params) {
  return request({
    url: process.env.PUTIN_API + "/material/clean/service",
    method: "POST",
    params
  });
}

/* 创建素材组 */
export function getCreateOrUpdate(data) {
  return request({
    url: process.env.PUTIN_API + "/material/group/createOrUpdate",
    method: "POST",
    data
  });
}

export function deriveTask(params) {
  return request({
    url: process.env.PUTIN_API + '/material/derive/tasks',
    method: 'GET',
    params
  })
}

export function createDeriveTask(data) {
  return request({
    url: process.env.PUTIN_API + '/material/create/derive',
    method: 'POST',
    data
  })
}

export function openDeriveTask(params) {
  return request({
    url: process.env.PUTIN_API + '/material/open/derive',
    method: 'POST',
    params
  })
}
