import request from '@/utils/request'

const baseUrl = '/location-groups'

// 获取所有地域组
export function getLocationGroupList(params) {
  return request({
    url: process.env.PUTIN_API + baseUrl,
    method: 'get',
    params
  })
}

// 根据ID获取地域组
export function getLocationGroupById(id) {
  return request({
    url: process.env.PUTIN_API + `${baseUrl}/${id}`,
    method: 'get'
  })
}

// 创建地域组
export function createLocationGroup(data) {
  return request({
    url: process.env.PUTIN_API + baseUrl,
    method: 'post',
    data
  })
}

// 更新地域组
export function updateLocationGroup(data) {
  return request({
    url: process.env.PUTIN_API + `${baseUrl}/${data.id}`,
    method: 'put',
    data
  })
}

// 删除地域组
export function deleteLocationGroup(id) {
  return request({
    url: process.env.PUTIN_API + `${baseUrl}/${id}`,
    method: 'delete'
  })
}
