/**
 * 语言配置文件
 * 用于统一管理系统中使用的语言选项
 */

// 语言代码到名称的映射
export const languageMap = {
  en: "英语",
  zh: "中文",
  ja: "日语",
  ko: "韩语",
  fr: "法语",
  de: "德语",
  es: "西班牙语",
  pt: "葡萄牙语",
  ru: "俄语",
  hi: "印地语"
};

// 语言选项，用于下拉菜单
export const languageOptions = [
  { label: "英语", value: "en" },
  { label: "中文", value: "zh" },
  { label: "日语", value: "ja" },
  { label: "韩语", value: "ko" },
  { label: "法语", value: "fr" },
  { label: "德语", value: "de" },
  { label: "西班牙语", value: "es" },
  { label: "葡萄牙语", value: "pt" },
  { label: "俄语", value: "ru" },
  { label: "印地语", value: "hi" }
];

// 默认语言
export const defaultLanguage = "en";

// 根据语言代码获取语言名称
export const getLanguageName = (code) => {
  return languageMap[code] || code;
}; 