import request from '@/utils/request'

/**
 * 获取所有可用的Google开发者账号
 */
export function getAvailableDevelopers() {
  return request({
    url: process.env.PUTIN_API + '/google-developer/available',
    method: 'get'
  })
}

/**
 * 根据ID获取Google开发者账号
 * @param {number} id 开发者账号ID
 */
export function getDeveloperById(id) {
  return request({
    url: process.env.PUTIN_API + `/google-developer/${id}`,
    method: 'get'
  })
}

/**
 * 获取Google授权链接
 * @param {number} googleDeveloperId 开发者账号ID
 */
export function getGoogleAuthUrl(googleDeveloperId) {
  return request({
    url: process.env.PUTIN_API + `/youtube/auth-url/${googleDeveloperId}`,
    method: 'get'
  })
} 