import request from '@/utils/request'

const baseUrl = '/app-groups'

// 获取所有产品组
export function getAppGroupList(params) {
  return request({
    url: process.env.PUTIN_API + baseUrl,
    method: 'get',
    params
  })
}

// 根据ID获取产品组
export function getAppGroupById(id) {
  return request({
    url: process.env.PUTIN_API + `${baseUrl}/${id}`,
    method: 'get'
  })
}

// 创建产品组
export function createAppGroup(data) {
  return request({
    url: process.env.PUTIN_API + baseUrl,
    method: 'post',
    data
  })
}

// 更新产品组
export function updateAppGroup(data) {
  return request({
    url: process.env.PUTIN_API + `${baseUrl}/${data.id}`,
    method: 'put',
    data
  })
}

// 删除产品组
export function deleteAppGroup(id) {
  return request({
    url: process.env.PUTIN_API + `${baseUrl}/${id}`,
    method: 'delete'
  })
}

// 获取所有APP列表
export function getAllApps() {
  return request({
    url: process.env.PUTIN_API + '/apps',
    method: 'get'
  })
}
