import Vue from 'vue'
import Vuex from 'vuex'
import app from './modules/app'
import user from './modules/user'
import recommendMaterial from './modules/recommendMaterial'
import getters from './getters'

Vue.use(Vuex)

const state = {
  /* 便捷时间选择器 */
  pickerOptions: {
    shortcuts: [{
      text: '今天',
      onClick(picker) {
        const end = new Date();
        const start = new Date();
        start.setTime(start.getTime());
        picker.$emit('pick', [start, end]);
      }
    }, {
      text: '最近3天',
      onClick(picker) {
        const end = new Date();
        const start = new Date();
        start.setTime(start.getTime() - 3600 * 1000 * 24 * 3);
        picker.$emit('pick', [start, end]);
      }
    }, {
      text: '最近一周',
      onClick(picker) {
        const end = new Date();
        const start = new Date();
        start.setTime(start.getTime() - 3600 * 1000 * 24 * 7);
        picker.$emit('pick', [start, end]);
      }
    }, {
      text: '最近一个月',
      onClick(picker) {
        const end = new Date();
        const start = new Date();
        start.setTime(start.getTime() - 3600 * 1000 * 24 * 30);
        picker.$emit('pick', [start, end]);
      }
    }, {
      text: '最近三个月',
      onClick(picker) {
        const end = new Date();
        const start = new Date();
        start.setTime(start.getTime() - 3600 * 1000 * 24 * 90);
        picker.$emit('pick', [start, end]);
      }
    }]
  },
}

const store = new Vuex.Store({
  state,
  modules: {
    app,
    user,
    recommendMaterial
  },
  getters
})

export default store
