// in development-env not use lazy-loading, because lazy-loading too many pages will cause webpack hot update too slow. so only in production use lazy-loading;
// detail: https://panjiachen.github.io/vue-element-admin-site/#/lazy-loading

import Vue from "vue";
import Router from "vue-router";
import Layout from "../views/layout/Layout";

export const constantRouterMap = [
  {
    path: "/login", // 登录页面
    name: "login",
    component: () => import("@/views/login/index"),
    hidden: true
  },
  {
    path: "*", // 页面不存在
    component: () => import("@/views/404"),
    hidden: true
  },
  {
    path: "/", // 根目录
    name: "index",
    redirect: "/index", // 重定向到退款管理
    component: Layout,
    meta: {
      title: "首页",
      icon: "message"
    },
    children: [
      {
        path: "/index", // 首页
        name: "index",
        component: () => import("@/views/index/index"),
        meta: { title: "首页", icon: "message" }
      }
    ]
  },

  {
    path: "/putManagement/putManagement", // 账号授权管理
    name: "appLaunchManage",
    component: Layout,
    meta: {
      title: "账号授权管理",
      icon: "form"
    },
    children: [
      {
        path: "/putManagement/putManagement", // 账号授权管理
        name: "appLaunchManage",
        component: () => import("@/views/putManagement/index"),
        meta: { title: "账号授权管理", icon: "form" }
      }
    ]
  },

  {
    path: "/intelligentDelivery", // 推广管理
    name: "intelligentDelivery",
    component: Layout,
    meta: {
      title: "推广管理",
      icon: "chart"
    },
    children: [
      {
        path: "/intelligentDelivery/account-manager", // 媒体账号管理
        name: "intelligentDelivery.account-manager",
        component: () => import('@/views/promotionManagement/AccountManagement'),
        meta: { title: "媒体账号管理", icon: "user" }
      },

      {
        path: '/intelligentDelivery/campaign-task',
        name: "intelligentDelivery.campaign-task",
        component: () => import('@/views/campaignTask/CampaignTaskManage'),
        meta: { title: '计划投放' }
      },

      {
        path: '/intelligentDelivery/campaign-template',
        name: "intelligentDelivery.campaign-template",
        component: () => import('@/views/campaignTemplate/CampaignTemplateManage'),
        meta: { title: '计划模板管理' }
      },
      
    ]
  },
  {
    path: "/assetManagement", // 资产管理
    name: "assetManagement",
    component: Layout,
    meta: {
      title: "资产管理",
      icon: "chart"
    },
    children: [
      {
        path: "/assetManagement/createMaterial",
        name: "assetManagement.createMaterial",
        component: () => import("@/views/createMaterial"),
        meta: { title: "创意素材", icon: "chart" }
      },

      {
        path: '/assetManagement/app-group',
        name: "assetManagement.app-group",
        component: () => import('@/views/appGroup/AppGroupManage'),
        meta: { title: '产品组管理' }
      },

      {
        path: "/tools/googleOauthYoutube",
        name: "tools.youtubeacountrights",
        component: () => import("@/views/authAccount/googleOauthYoutube"),
        meta: { title: "Youtube账号授权", icon: "chart" }
      },
      {
        path: "/tools/uploadYoutube",
        name: "tools.youtubeuploadvideo",
        component: () => import("@/views/uploadYoutube/uploadYoutube"),
        meta: { title: "Youtube视频上传", icon: "chart" }
      },{
        path: "/tools/YoutubeVideoManage",
        name: "tools.YoutubeVideoManage",
        component: () => import("@/views/uploadYoutube/YoutubeVideoManage"),
        meta: { title: "Youtube视频管理", icon: "chart" }
      },
      {
        path: "/assetManagement/copywritingLibrary",
        name: "assetManagement.copywritingLibrary",
        component: () => import("@/views/copywritingLibrary"),
        meta: { title: "文案库", icon: "document" }
      },
      {
        path: '/assetManagement/location-group',
        name: 'assetManagement.location-group',
        component: () => import('@/views/locationGroup/LocationGroupManage'),
        meta: { title: '地域组管理' }
      },
      {
        path: '/assetManagement/title-group',
        name: 'assetManagement.title-group',
        component: () => import('@/views/titleGroup/TitleGroupManage'),
        meta: { title: '标题组管理' }
      },
      {
        path: '/assetManagement/description-group',
        name: 'assetManagement.description-group',
        component: () => import('@/views/descriptionGroup/DescriptionGroupManage'),
        meta: { title: '描述组管理' }
      },
      {
        path: '/assetManagement/material-tag',
        name: 'assetManagement.material-tag',
        component: () => import('@/views/materialTag'),
        meta: { title: '标签管理' }
      },
      {
        path: '/assetManagement/material-group',
        name: 'assetManagement.material-group',
        component: () => import('@/views/materialGroup'),
        meta: { title: '素材组管理' }
      },
      {
        path: '/assetManagement/resource-group',
        name: 'assetManagement.resource-group',
        component: () => import('@/views/resourceGroup'),
        meta: { title: '资源组管理' }
      },

      {
        path: "/assetManagement/materialManage",
        name: "assetManagement.materialManage",
        component: () => import("@/views/createMaterial/MaterialManage"),
        meta: { title: "素材管理", icon: "chart" }
      },
      
    ]
  },

  {
    path: "/promotionManagement", // 推广管理
    name: "promotionManagement",
    component: Layout,
    meta: {
      title: "推广管理",
      icon: "form"
    },
    children: [
      {
        path: "/promotionManagement/account", // 账号管理
        name: "promotionManagement.account",
        component: () => import('@/views/promotionManagement/AccountManagement'),
        meta: { title: "账号管理", icon: "user" }
      }
    ]
  },

  {
    path: "/tools", // 资产管理
    name: "tools",
    component: Layout,
    meta: {
      title: "工具",
      icon: "chart"
    },
    children: [   
      {
        path: "/materialUpload", // 资产上传
        name: "materialUpload",
        component: () => import('@/views/createMaterial/MaterialUpload'),
        hidden: true
      },

      {
        path: "/materialTag", // 素材标签管理
        name: "materialTag",
        component: () => import('@/views/materialTag'),
        hidden: true
      }
    ]
  },

  {
    path: '/redirect', // 重定向路由
    component: Layout,
    hidden: true,
    children: [{
      path: '',
      component: () => import('@/views/layout/components/Sidebar/redirect')
    }]
  },

  {
    path: "/privacy", // 隐私协议页面
    name: "privacy",
    component: () => import("@/views/privacy/index"),
    hidden: true
  },

  {
    path: "/facebook-auth", // Facebook三方授权页面
    name: "facebook-auth",
    component: () => import("@/views/auth/FacebookAuth"),
    hidden: true
  },
];

Vue.use(Router);

export default new Router({
  mode: "history", // 后端支持可开
  scrollBehavior: () => ({ y: 0 }),
  routes: constantRouterMap
});
