import axios from 'axios'

// 获取所有标题组
export function getTitleGroupList() {
  return axios.get(process.env.PUTIN_API + '/title-groups')
    .then(response => {
      return response.data
    })
}

// 获取单个标题组
export function getTitleGroupById(id) {
  return axios.get(`${process.env.PUTIN_API}/title-groups/${id}`)
    .then(response => {
      return response.data
    })
}

// 创建标题组
export function createTitleGroup(data) {
  return axios.post(`${process.env.PUTIN_API}/title-groups`, data)
    .then(response => {
      return response.data
    })
}

// 更新标题组
export function updateTitleGroup(id, data) {
  return axios.put(`${process.env.PUTIN_API}/title-groups/${id}`, data)
    .then(response => {
      return response.data
    })
}

// 删除标题组
export function deleteTitleGroup(id) {
  return axios.delete(`${process.env.PUTIN_API}/title-groups/${id}`)
    .then(response => {
      return response.data
    })
}
